/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes.actions;

import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.base.ResourceDefinitionContext;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.ActionTimeoutException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.kubernetes.KubernetesSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;
import org.citrusframework.yaks.kubernetes.actions.AbstractKubernetesAction;
import org.springframework.util.StringUtils;

public class VerifyCustomResourceAction
extends AbstractKubernetesAction {
    private final String resourceName;
    private final String type;
    private final String version;
    private final String kind;
    private final String group;
    private final String labelExpression;
    private final int maxAttempts;
    private final long delayBetweenAttempts;
    private final String condition;

    public VerifyCustomResourceAction(Builder builder) {
        super("verify-pod-status", builder);
        this.resourceName = builder.resourceName;
        this.type = builder.type;
        this.group = builder.group;
        this.version = builder.version;
        this.kind = builder.kind;
        this.labelExpression = builder.labelExpression;
        this.condition = builder.condition;
        this.maxAttempts = builder.maxAttempts;
        this.delayBetweenAttempts = builder.delayBetweenAttempts;
    }

    public void doExecute(TestContext context) {
        this.verifyResource(context.replaceDynamicContentInString(this.resourceName), context.replaceDynamicContentInString(this.labelExpression), context.replaceDynamicContentInString(this.condition), context);
    }

    private void verifyResource(String name, String labelExpression, String condition, TestContext context) {
        for (int i = 0; i < this.maxAttempts; ++i) {
            GenericKubernetesResource resource = name != null && !name.isEmpty() ? this.getResource(name, condition, context) : this.getResourceFromLabel(labelExpression, condition, context);
            if (resource != null) {
                this.LOG.info(String.format("Verified resource '%s' state '%s'!", this.getNameOrLabel(name, labelExpression), condition));
                return;
            }
            this.LOG.warn(String.format("Waiting for resource '%s' in state '%s' - retry in %s ms", this.getNameOrLabel(name, labelExpression), condition, this.delayBetweenAttempts));
            try {
                Thread.sleep(this.delayBetweenAttempts);
                continue;
            }
            catch (InterruptedException e) {
                this.LOG.warn("Interrupted while waiting for resource condition", (Throwable)e);
            }
        }
        throw new ActionTimeoutException((long)this.maxAttempts * this.delayBetweenAttempts, (Throwable)new CitrusRuntimeException(String.format("Failed to verify resource '%s' - is not in state '%s' after %d attempts", this.getNameOrLabel(name, labelExpression), condition, this.maxAttempts)));
    }

    private GenericKubernetesResource getResource(String name, String condition, TestContext context) {
        GenericKubernetesResource resource = KubernetesSupport.getResource(this.getKubernetesClient(), this.namespace(context), this.getCrdContext(context), name);
        return this.verifyResourceStatus(resource, condition) ? resource : null;
    }

    private GenericKubernetesResource getResourceFromLabel(String labelExpression, String condition, TestContext context) {
        if (labelExpression == null || labelExpression.isEmpty()) {
            return null;
        }
        String[] tokens = labelExpression.split("=");
        String labelKey = tokens[0];
        String labelValue = tokens.length > 1 ? tokens[1] : "";
        GenericKubernetesResourceList resourceList = KubernetesSupport.getResources(this.getKubernetesClient(), this.namespace(context), this.getCrdContext(context), labelKey, labelValue);
        return resourceList.getItems().stream().filter(resource -> this.verifyResourceStatus((GenericKubernetesResource)resource, condition)).findFirst().orElse(null);
    }

    private boolean verifyResourceStatus(GenericKubernetesResource resource, String condition) {
        Map<String, Object> status = this.getAsPropertyMap("status", resource.getAdditionalProperties());
        List<Map<String, Object>> conditions = this.getAsPropertyList("conditions", status);
        return conditions.stream().anyMatch(propertyMap -> propertyMap.getOrDefault("type", "").equals(condition) && Optional.ofNullable(propertyMap.get("status")).map(b -> Boolean.valueOf(b.toString())).orElse(false) != false);
    }

    private ResourceDefinitionContext getCrdContext(TestContext context) {
        return KubernetesSupport.crdContext(context.replaceDynamicContentInString(this.type), context.replaceDynamicContentInString(this.group), context.replaceDynamicContentInString(this.kind), context.replaceDynamicContentInString(this.version));
    }

    private String getNameOrLabel(String name, String labelExpression) {
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return labelExpression;
    }

    private Map<String, Object> getAsPropertyMap(String property, Map<String, Object> objectMap) {
        if (objectMap != null && objectMap.containsKey(property) && objectMap.get(property) instanceof Map) {
            return (Map)objectMap.get(property);
        }
        return Collections.emptyMap();
    }

    private List<Map<String, Object>> getAsPropertyList(String property, Map<String, Object> objectMap) {
        if (objectMap.containsKey(property) && objectMap.get(property) instanceof List) {
            return ((List)objectMap.get(property)).stream().map(item -> (Map)item).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static final class Builder
    extends AbstractKubernetesAction.Builder<VerifyCustomResourceAction, Builder> {
        private String resourceName;
        private String labelExpression;
        private int maxAttempts = KubernetesSettings.getMaxAttempts();
        private long delayBetweenAttempts = KubernetesSettings.getDelayBetweenAttempts();
        private String condition = "Ready";
        private String type;
        private String version = "v1";
        private String kind;
        private String group;

        public Builder resourceName(String name) {
            if (name.contains("/")) {
                String[] tokens = name.split("/");
                if (this.kind == null) {
                    this.kind(StringUtils.capitalize((String)tokens[0]));
                }
                this.resourceName = tokens.length > 1 ? tokens[1] : "";
            } else {
                this.resourceName = name;
            }
            return this;
        }

        public Builder type(String resourceType) {
            if (resourceType.contains("/")) {
                String[] tokens = resourceType.split("/");
                this.type = tokens[0];
                if (this.group == null) {
                    this.group(this.type.substring(this.type.indexOf(".") + 1));
                }
                if (tokens.length > 1) {
                    this.version(tokens[1]);
                }
            } else {
                this.type = resourceType;
            }
            return this;
        }

        public Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public Builder group(String group) {
            this.group = group;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder apiVersion(String apiVersion) {
            String[] groupAndVersion = apiVersion.split("/");
            this.group(groupAndVersion[0]);
            this.version(groupAndVersion[1]);
            return this;
        }

        public Builder condition(String value) {
            this.condition = value;
            return this;
        }

        public Builder isAvailable() {
            this.condition("Available");
            return this;
        }

        public Builder isReady() {
            this.condition("Ready");
            return this;
        }

        public Builder label(String name, String value) {
            this.labelExpression = String.format("%s=%s", name, value);
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder delayBetweenAttempts(long delayBetweenAttempts) {
            this.delayBetweenAttempts = delayBetweenAttempts;
            return this;
        }

        public VerifyCustomResourceAction build() {
            return new VerifyCustomResourceAction(this);
        }
    }
}

