/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.kubernetes.functions;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import java.util.List;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.exceptions.InvalidFunctionUsageException;
import org.citrusframework.functions.Function;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSupport;

public class ServiceClusterIpFunction
implements Function {
    public String execute(List<String> parameterList, TestContext context) {
        if (YaksSettings.isLocal()) {
            return "127.0.0.1";
        }
        if (parameterList.isEmpty()) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty - please provide a proper service name");
        }
        String serviceName = parameterList.get(0);
        String namespace = parameterList.size() > 1 ? parameterList.get(1) : KubernetesSupport.getNamespace(context);
        KubernetesClient k8sClient = KubernetesSupport.getKubernetesClient(context);
        Service service = (Service)((ServiceResource)((NonNamespaceOperation)k8sClient.services().inNamespace(namespace)).withName(serviceName)).get();
        if (service == null) {
            throw new CitrusRuntimeException(String.format("Unable to resolve service instance %s/%s", namespace, serviceName));
        }
        String clusterIp = service.getSpec().getClusterIP();
        if (clusterIp != null) {
            return clusterIp;
        }
        if (!service.getSpec().getExternalIPs().isEmpty()) {
            return (String)service.getSpec().getExternalIPs().get(0);
        }
        throw new CitrusRuntimeException(String.format("Unable to resolve cluster ip on service instance %s - no cluster ip set", service.getMetadata().getName()));
    }
}

