/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.report;

import com.consol.citrus.report.AbstractTestSuiteListener;
import com.consol.citrus.report.LoggingReporter;
import com.consol.citrus.report.OutputStreamReporter;
import com.consol.citrus.report.TestReporter;
import com.consol.citrus.report.TestResults;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOutTestReporter
extends AbstractTestSuiteListener
implements TestReporter {
    private static final Logger LOG = LoggerFactory.getLogger(SystemOutTestReporter.class);
    private final OutputStreamReporter delegate = new OutputStreamReporter((Writer)new BufferedWriter(new OutputStreamWriter(System.out)));

    public SystemOutTestReporter() {
        this.delegate.setFormat("%s | %s%n");
    }

    public void onStart() {
        if (!LoggerFactory.getLogger(LoggingReporter.class).isInfoEnabled()) {
            try {
                this.delegate.onStart();
                this.delegate.getLogWriter().flush();
            }
            catch (IOException e) {
                LOG.warn("Failed to initialize test report", (Throwable)e);
            }
        }
    }

    public void generateReport(TestResults testResults) {
        if (!LoggerFactory.getLogger(LoggingReporter.class).isInfoEnabled()) {
            try {
                this.delegate.generateReport(testResults);
                this.delegate.getLogWriter().flush();
            }
            catch (IOException e) {
                LOG.warn("Failed to write test summary report", (Throwable)e);
            }
        }
    }

    public void destroy() throws Exception {
        this.delegate.getLogWriter().close();
    }
}

