/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.standard;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.actions.PurgeEndpointAction;
import com.consol.citrus.actions.StartServerAction;
import com.consol.citrus.actions.StopServerAction;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.server.Server;
import io.cucumber.java.en.Given;

public class EndpointSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;

    @Given(value="^start server component ([^\"\\s]+)$")
    public void startServer(String name) {
        if (this.citrus.getCitrusContext().getReferenceResolver().isResolvable(name)) {
            Server server = (Server)this.citrus.getCitrusContext().getReferenceResolver().resolve(name, Server.class);
            if (!server.isRunning()) {
                this.runner.run((TestActionBuilder)StartServerAction.Builder.start((Server)server));
            }
        } else {
            throw new CitrusRuntimeException(String.format("Unable to find server component '%s'", name));
        }
    }

    @Given(value="^stop server component ([^\"\\s]+)$")
    public void stopServer(String name) {
        if (this.citrus.getCitrusContext().getReferenceResolver().isResolvable(name)) {
            Server server = (Server)this.citrus.getCitrusContext().getReferenceResolver().resolve(name, Server.class);
            if (server.isRunning()) {
                this.runner.run((TestActionBuilder)StopServerAction.Builder.stop((Server)server));
            }
        } else {
            throw new CitrusRuntimeException(String.format("Unable to find server component '%s'", name));
        }
    }

    @Given(value="^purge endpoint ([^\"\\s]+)$")
    public void purgeEndpoint(String name) {
        if (!this.citrus.getCitrusContext().getReferenceResolver().isResolvable(name)) {
            throw new CitrusRuntimeException(String.format("Unable to find endpoint '%s'", name));
        }
        Endpoint endpoint = (Endpoint)this.citrus.getCitrusContext().getReferenceResolver().resolve(name, Endpoint.class);
        this.runner.run((TestActionBuilder)PurgeEndpointAction.Builder.purgeEndpoints().endpoint(endpoint));
    }
}

