/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.message;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.message.Message;
import org.citrusframework.util.ReflectionHelper;
import org.citrusframework.yaks.message.CreatesMessage;
import org.citrusframework.yaks.message.MessageCreator;

public class MessageCreators {
    private final Map<String, MessageCreator> messageCreators = new HashMap<String, MessageCreator>();
    private final List<Object> pojoCreators = new ArrayList<Object>();

    public Message createMessage(String messageName) {
        if (this.messageCreators.containsKey(messageName)) {
            return this.messageCreators.get(messageName).create();
        }
        Message[] message = new Message[]{null};
        for (Object messageCreator : this.pojoCreators) {
            ReflectionHelper.doWithMethods(messageCreator.getClass(), method -> {
                if (((CreatesMessage[])method.getAnnotationsByType(CreatesMessage.class)).length == 0) {
                    return;
                }
                if (method.getAnnotation(CreatesMessage.class).value().equals(messageName)) {
                    try {
                        message[0] = (Message)method.invoke(messageCreator, new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw new CitrusRuntimeException("Unsupported message creator method: " + method.getName(), (Throwable)e);
                    }
                }
            });
        }
        if (message[0] == null) {
            throw new CitrusRuntimeException("Unable to find message creator for message: " + messageName);
        }
        return message[0];
    }

    public void add(String name, MessageCreator creator) {
        this.messageCreators.put(name, creator);
    }

    public void addType(String type) {
        try {
            Object messageCreator = Class.forName(type).newInstance();
            if (messageCreator instanceof MessageCreator) {
                this.messageCreators.put(messageCreator.getClass().getSimpleName(), (MessageCreator)messageCreator);
            }
            this.pojoCreators.add(messageCreator);
        }
        catch (ClassNotFoundException | IllegalAccessException e) {
            throw new CitrusRuntimeException("Unable to access message creator type: " + type, (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new CitrusRuntimeException("Unable to create  message creator instance of type: " + type, (Throwable)e);
        }
    }
}

