/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.UUID;

public class TestResult {
    private final UUID id;
    private final String name;
    private final String classname;
    private Throwable cause;

    public TestResult(UUID id, String name, String classname) {
        this.id = id;
        this.name = name;
        this.classname = classname;
    }

    public TestResult(UUID id, String name, String classname, Throwable cause) {
        this.id = id;
        this.name = name;
        this.classname = classname;
        this.cause = cause;
    }

    @JsonIgnore
    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getClassname() {
        return this.classname;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getErrorType() {
        if (this.cause == null) {
            return null;
        }
        return this.cause.getClass().getName();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getErrorMessage() {
        if (this.cause == null) {
            return null;
        }
        return this.cause.getMessage();
    }

    public void setCause(Throwable cause) {
        this.cause = cause;
    }

    @JsonIgnore
    public Throwable getCause() {
        return this.cause;
    }
}

