/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.report;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.citrusframework.yaks.report.TestResult;
import org.citrusframework.yaks.report.TestSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestResults {
    private static final Logger LOG = LoggerFactory.getLogger(TestResults.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String suiteName = "yaks-test-suite";
    private final TestSummary summary = new TestSummary();
    private final List<TestResult> tests = new ArrayList<TestResult>();

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public List<TestResult> getTests() {
        return this.tests;
    }

    public TestSummary getSummary() {
        return this.summary;
    }

    @JsonIgnore
    public void addTestResult(TestResult result) {
        this.tests.add(result);
    }

    @JsonIgnore
    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Failed to create test result Json report", (Throwable)e);
            return "";
        }
    }
}

