/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.standard;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.EchoAction;
import org.citrusframework.actions.LoadPropertiesAction;
import org.citrusframework.actions.SleepAction;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.citrusframework.yaks.util.ResourceUtils;

public class StandardSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;

    @Given(value="^YAKS does Cloud-Native BDD testing$")
    public void itDoesBDD() {
        this.print("YAKS does Cloud-Native BDD testing");
    }

    @Then(value="^YAKS rocks!$")
    public void yaksRocks() {
        this.print("YAKS rocks!");
    }

    @Given(value="^variable ([^\\s]+) (?:is|=) \"([^\"]*)\"$")
    public void variable(String name, String value) {
        this.runner.variable(name, (Object)value);
    }

    @Given(value="^variable ([^\\s]+)=\"([^\"]*)\"$")
    public void variableDeclaration(String name, String value) {
        this.runner.variable(name, (Object)value);
    }

    @Given(value="^variable ([^\\s]+) (?:is|=)$")
    public void variableMultiline(String name, String value) {
        this.runner.variable(name, (Object)value);
    }

    @Given(value="^load variable ([^\\s]+)\\.([a-z0-9-]+)$")
    public void loadVariable(String name, String fileExtension) {
        this.loadVariableFromFile(name, name + "." + fileExtension);
    }

    @Given(value="^load variable ([^\\s]+) from ([^\\s]+)$")
    public void loadVariableFromFile(String name, String file) {
        try {
            this.variable(name, FileUtils.readToString((Resource)ResourceUtils.resolve(file, this.context)));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException(String.format("Failed to load body from file resource %s", file));
        }
    }

    @Given(value="^load variables ([^\\s]+)$")
    public void loadVariables(String file) {
        this.runner.run((TestActionBuilder)LoadPropertiesAction.Builder.load((String)file));
    }

    @Given(value="^variables$")
    public void variables(DataTable dataTable) {
        Map variables = dataTable.asMap(String.class, String.class);
        for (Map.Entry entry : variables.entrySet()) {
            this.runner.variable((String)entry.getKey(), (Object)((String)entry.getValue()));
        }
    }

    @Then(value="^(?:log|print) '(.+)'$")
    public void print(String message) {
        this.runner.run((TestActionBuilder)EchoAction.Builder.echo((String)message));
    }

    @Then(value="^(?:log|print)$")
    public void printMultiline(String message) {
        this.runner.run((TestActionBuilder)EchoAction.Builder.echo((String)message));
    }

    @Then(value="^sleep$")
    public void doSleep() {
        this.runner.then((TestActionBuilder)SleepAction.Builder.sleep());
    }

    @Then(value="^sleep (\\d+) ms$")
    public void doSleep(long milliseconds) {
        this.runner.then((TestActionBuilder)SleepAction.Builder.sleep().milliseconds(Long.valueOf(milliseconds)));
    }

    @Then(value="^sleep( \\d+h)?( \\d+min)?( \\d+sec)?( \\d+ms)?$")
    public void doSleep(String hours, String min, String sec, String milliseconds) {
        StringBuilder time = new StringBuilder("PT");
        if (hours != null) {
            time.append(String.format("%sH", hours.substring(0, hours.indexOf("h")).trim()));
        }
        if (min != null) {
            time.append(String.format("%sM", min.substring(0, min.indexOf("m")).trim()));
        }
        if (sec != null) {
            time.append(String.format("%sS", sec.substring(0, sec.indexOf("s")).trim()));
        }
        long ms = 0L;
        if (milliseconds != null) {
            ms = Long.parseLong(milliseconds.substring(0, milliseconds.indexOf("m")).trim());
        }
        this.runner.then((TestActionBuilder)SleepAction.Builder.sleep().milliseconds(Long.valueOf(Duration.parse(time.toString()).toMillis() + ms)));
    }
}

