/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Optional;
import org.citrusframework.CitrusSettings;
import org.citrusframework.yaks.YaksClusterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YaksSettings {
    private static final Logger LOG = LoggerFactory.getLogger(YaksSettings.class);
    private static final String YAKS_PROPERTY_PREFIX = "yaks.";
    private static final String YAKS_ENV_PREFIX = "YAKS_";
    private static final String CLUSTER_WILDCARD_DOMAIN_PROPERTY = "cluster.wildcard.domain";
    private static final String CLUSTER_WILDCARD_DOMAIN_ENV = "CLUSTER_WILDCARD_DOMAIN";
    public static final String DEFAULT_DOMAIN_SUFFIX = "svc.cluster.local";
    private static final String NAMESPACE_PROPERTY = "yaks.namespace";
    private static final String NAMESPACE_ENV = "YAKS_NAMESPACE";
    private static final String NAMESPACE_DEFAULT = "default";
    private static final String OPERATOR_NAMESPACE_PROPERTY = "yaks.namespace";
    private static final String OPERATOR_NAMESPACE_ENV = "YAKS_NAMESPACE";
    private static final String CLUSTER_TYPE_PROPERTY = "yaks.cluster.type";
    private static final String CLUSTER_TYPE_ENV = "YAKS_CLUSTER_TYPE";
    private static final String CLUSTER_TYPE_DEFAULT = YaksClusterType.KUBERNETES.name();
    private static final String TEST_ID_PROPERTY = "yaks.test.id";
    private static final String TEST_ID_ENV = "YAKS_TEST_ID";
    private static final String TEST_ID_DEFAULT = "yaks-test";
    private static final String DEFAULT_MESSAGE_TYPE_PROPERTY = "yaks.default.message.type";
    private static final String DEFAULT_MESSAGE_TYPE_ENV = "YAKS_DEFAULT_MESSAGE_TYPE";
    private static final String DEFAULT_MESSAGE_TYPE_DEFAULT = CitrusSettings.DEFAULT_MESSAGE_TYPE;
    private static final String TERMINATION_LOG_PROPERTY = "yaks.termination.log";
    private static final String TERMINATION_LOG_ENV = "YAKS_TERMINATION_LOG";
    private static final String TERMINATION_LOG_DEFAULT = "target/termination.log";

    public static String getOperatorNamespace() {
        return Optional.ofNullable(System.getProperty("yaks.namespace", System.getenv("YAKS_NAMESPACE"))).orElseGet(() -> YaksSettings.getClusterType().operatorNamespace());
    }

    public static String getDefaultNamespace() {
        String systemNamespace = System.getProperty("yaks.namespace", System.getenv("YAKS_NAMESPACE"));
        if (systemNamespace != null) {
            return systemNamespace;
        }
        File namespace = new File("/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        if (namespace.exists()) {
            try {
                return Files.readString(namespace.toPath());
            }
            catch (IOException e) {
                LOG.warn("Failed to read Kubernetes namespace from filesystem {}", (Object)namespace, (Object)e);
            }
        }
        return NAMESPACE_DEFAULT;
    }

    public static String getClusterWildcardDomain() {
        return System.getProperty(CLUSTER_WILDCARD_DOMAIN_PROPERTY, (String)(System.getenv(CLUSTER_WILDCARD_DOMAIN_ENV) != null ? System.getenv(CLUSTER_WILDCARD_DOMAIN_ENV) : YaksSettings.getDefaultNamespace() + ".svc.cluster.local"));
    }

    public static YaksClusterType getClusterType() {
        return YaksClusterType.valueOf(System.getProperty(CLUSTER_TYPE_PROPERTY, System.getenv(CLUSTER_TYPE_ENV) != null ? System.getenv(CLUSTER_TYPE_ENV) : CLUSTER_TYPE_DEFAULT).toUpperCase(Locale.US));
    }

    public static Path getTerminationLog() {
        return Paths.get(System.getProperty(TERMINATION_LOG_PROPERTY, System.getenv(TERMINATION_LOG_ENV) != null ? System.getenv(TERMINATION_LOG_ENV) : TERMINATION_LOG_DEFAULT), new String[0]);
    }

    public static String getTestId() {
        return System.getProperty(TEST_ID_PROPERTY, Optional.ofNullable(System.getenv(TEST_ID_ENV)).orElse(TEST_ID_DEFAULT));
    }

    public static String getDefaultMessageType() {
        return System.getProperty(DEFAULT_MESSAGE_TYPE_PROPERTY, Optional.ofNullable(System.getenv(DEFAULT_MESSAGE_TYPE_ENV)).orElse(DEFAULT_MESSAGE_TYPE_DEFAULT));
    }

    public static boolean isLocal() {
        return YaksSettings.isLocal(YaksSettings.getClusterType());
    }

    public static boolean isLocal(YaksClusterType clusterType) {
        return YaksClusterType.LOCAL.equals((Object)clusterType);
    }

    public static boolean isOpenshiftCluster() {
        return YaksClusterType.OPENSHIFT.equals((Object)YaksSettings.getClusterType());
    }

    public static boolean isKubernetesCluster() {
        return YaksClusterType.KUBERNETES.equals((Object)YaksSettings.getClusterType());
    }
}

