/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.hooks;

import io.cucumber.java.After;
import io.cucumber.java.Scenario;
import io.cucumber.java.Status;
import org.citrusframework.TestAction;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.actions.AbstractTestAction;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.util.CucumberUtils;

public class TestFailureHook {
    @CitrusResource
    private TestCaseRunner runner;

    @After(order=0x7FFFFFFF)
    public void checkTestFailure(Scenario scenario) {
        if (scenario.isFailed()) {
            this.runner.run((TestAction)new AddErrorAction(String.format("Scenario '%s' in %s status %s", scenario.getName(), CucumberUtils.extractFeatureFileName(scenario), scenario.getStatus().toString())));
        } else if (Status.PENDING == scenario.getStatus() || Status.UNDEFINED == scenario.getStatus()) {
            this.runner.run((TestAction)new AddErrorAction(String.format("Scenario '%s' in %s has pending or undefined step(s)", scenario.getName(), CucumberUtils.extractFeatureFileName(scenario))));
        }
    }

    private static class AddErrorAction
    extends AbstractTestAction {
        private final String errorMessage;

        public AddErrorAction(String msg) {
            this.errorMessage = msg;
        }

        public void doExecute(TestContext context) {
            context.getExceptions().add(new CitrusRuntimeException(this.errorMessage));
        }
    }
}

