/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.report;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.citrusframework.report.AbstractTestSuiteListener;
import org.citrusframework.report.LoggingReporter;
import org.citrusframework.report.OutputStreamReporter;
import org.citrusframework.report.TestReporter;
import org.citrusframework.report.TestResults;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOutTestReporter
extends AbstractTestSuiteListener
implements TestReporter {
    private static final Logger LOG = LoggerFactory.getLogger(SystemOutTestReporter.class);
    private final OutputStreamReporter delegate = new OutputStreamReporter((Writer)new OutputStreamWriter(System.out));

    public SystemOutTestReporter() {
        this.delegate.setFormat("%s | %s%n");
    }

    public void onStart() {
        if (!LoggerFactory.getLogger(LoggingReporter.class).isInfoEnabled()) {
            try {
                this.delegate.onStart();
                this.delegate.getLogWriter().flush();
            }
            catch (IOException e) {
                LOG.warn("Failed to initialize test report", (Throwable)e);
            }
        }
    }

    public void generateReport(TestResults testResults) {
        if (!LoggerFactory.getLogger(LoggingReporter.class).isInfoEnabled()) {
            this.delegate.generateReport(testResults);
        }
    }

    public void destroy() throws Exception {
        try {
            this.delegate.getLogWriter().flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.delegate.getLogWriter().close();
    }
}

