/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.citrusframework.yaks.YaksClusterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YaksSettings {
    private static Logger LOG = LoggerFactory.getLogger(YaksSettings.class);
    private static final String YAKS_PROPERTY_PREFIX = "yaks.";
    private static final String YAKS_ENV_PREFIX = "YAKS_";
    private static final String CLUSTER_WILDCARD_DOMAIN_PROPERTY = "cluster.wildcard.domain";
    private static final String CLUSTER_WILDCARD_DOMAIN_ENV = "CLUSTER_WILDCARD_DOMAIN";
    public static final String DEFAULT_DOMAIN_SUFFIX = "svc.cluster.local";
    private static final String NAMESPACE_PROPERTY = "yaks.namespace";
    private static final String NAMESPACE_ENV = "YAKS_NAMESPACE";
    private static final String NAMESPACE_DEFAULT = "default";
    private static final String CLUSTER_TYPE_PROPERTY = "yaks.cluster.type";
    private static final String CLUSTER_TYPE_ENV = "YAKS_CLUSTER_TYPE";
    private static final String CLUSTER_TYPE_DEFAULT = YaksClusterType.KUBERNETES.name();
    private static final String TEST_ID_PROPERTY = "yaks.test.id";
    private static final String TEST_ID_ENV = "YAKS_TEST_ID";

    public static String getDefaultNamespace() {
        String systemNamespace = System.getProperty(NAMESPACE_PROPERTY, System.getenv(NAMESPACE_ENV));
        if (systemNamespace != null) {
            return systemNamespace;
        }
        File namespace = new File("/var/run/secrets/kubernetes.io/serviceaccount/namespace");
        if (namespace.exists()) {
            try {
                return new String(Files.readAllBytes(namespace.toPath()), StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LOG.warn("Failed to read Kubernetes namespace from filesystem {}", (Object)namespace, (Object)e);
            }
        }
        return NAMESPACE_DEFAULT;
    }

    public static String getClusterWildcardDomain() {
        return System.getProperty(CLUSTER_WILDCARD_DOMAIN_PROPERTY, (String)(System.getenv(CLUSTER_WILDCARD_DOMAIN_ENV) != null ? System.getenv(CLUSTER_WILDCARD_DOMAIN_ENV) : YaksSettings.getDefaultNamespace() + ".svc.cluster.local"));
    }

    public static YaksClusterType getClusterType() {
        return YaksClusterType.valueOf(System.getProperty(CLUSTER_TYPE_PROPERTY, System.getenv(CLUSTER_TYPE_ENV) != null ? System.getenv(CLUSTER_TYPE_ENV) : CLUSTER_TYPE_DEFAULT));
    }

    public static String getTestId() {
        return System.getProperty(TEST_ID_PROPERTY, System.getenv(TEST_ID_ENV));
    }

    public static boolean isOpenshiftCluster() {
        return YaksClusterType.OPENSHIFT.equals((Object)YaksSettings.getClusterType());
    }

    public static boolean isKubernetesCluster() {
        return YaksClusterType.KUBERNETES.equals((Object)YaksSettings.getClusterType());
    }
}

