/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.hooks;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.context.TestContext;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import java.util.Optional;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.YaksVariableNames;
import org.citrusframework.yaks.util.CucumberUtils;

public class InjectEnvVarsHook {
    @CitrusResource
    private TestCaseRunner runner;

    @Before
    public void injectEnvVars(final Scenario scenario) {
        this.runner.run((TestAction)new AbstractTestAction(){

            public void doExecute(TestContext context) {
                if (scenario != null) {
                    context.setVariable(YaksVariableNames.FEATURE_FILE.value(), (Object)CucumberUtils.extractFeatureFileName(scenario));
                    context.setVariable(YaksVariableNames.SCENARIO_ID.value(), (Object)scenario.getId());
                    context.setVariable(YaksVariableNames.SCENARIO_NAME.value(), (Object)scenario.getName());
                }
                Optional<String> namespaceEnv = InjectEnvVarsHook.this.getNamespaceSetting();
                Optional<String> domainEnv = InjectEnvVarsHook.this.getClusterWildcardSetting();
                if (namespaceEnv.isPresent()) {
                    context.setVariable(YaksVariableNames.NAMESPACE.value(), (Object)namespaceEnv.get());
                    if (!domainEnv.isPresent()) {
                        context.setVariable(YaksVariableNames.CLUSTER_WILDCARD_DOMAIN.value(), (Object)(namespaceEnv.get() + ".svc.cluster.local"));
                    }
                }
                domainEnv.ifPresent(var -> context.setVariable(YaksVariableNames.CLUSTER_WILDCARD_DOMAIN.value(), var));
            }
        });
    }

    protected Optional<String> getClusterWildcardSetting() {
        return Optional.ofNullable(YaksSettings.getClusterWildcardDomain());
    }

    protected Optional<String> getNamespaceSetting() {
        return Optional.ofNullable(YaksSettings.getDefaultNamespace());
    }
}

