/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.report;

import com.consol.citrus.cucumber.CitrusReporter;
import io.cucumber.java.PendingException;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.citrusframework.yaks.report.TestResult;
import org.citrusframework.yaks.report.TestResults;
import org.citrusframework.yaks.util.CucumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestReporter
extends CitrusReporter {
    private static final Logger LOG = LoggerFactory.getLogger(TestReporter.class);
    private static final String TERMINATION_LOG_DEFAULT = "target/termination.log";
    private static final String TERMINATION_LOG_PROPERTY = "yaks.termination.log";
    private static final String TERMINATION_LOG_ENV = "YAKS_TERMINATION_LOG";
    private final Pattern featureNamePattern = Pattern.compile("^Feature:(.+)$", 8);
    private final TestResults testResults = new TestResults();

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseFinished.class, this::saveTestResult);
        publisher.registerHandlerFor(TestCaseStarted.class, this::addTestDetail);
        publisher.registerHandlerFor(TestStepFinished.class, this::checkStepErrors);
        publisher.registerHandlerFor(TestSourceRead.class, this::setSuiteName);
        publisher.registerHandlerFor(TestRunFinished.class, this::printReports);
        super.setEventPublisher(publisher);
    }

    private void addTestDetail(TestCaseStarted event) {
        this.testResults.addTestResult(new TestResult(event.getTestCase().getId(), event.getTestCase().getName(), CucumberUtils.extractFeatureFileName(event.getTestCase().getUri().toString()) + ":" + event.getTestCase().getLine()));
    }

    private void checkStepErrors(TestStepFinished event) {
        if (event.getTestStep() instanceof HookTestStep) {
            return;
        }
        Optional<TestResult> testDetail = this.testResults.getTests().stream().filter(detail -> detail.getId().equals(event.getTestCase().getId())).findFirst();
        if (event.getResult().getError() != null) {
            if (testDetail.isPresent()) {
                testDetail.get().setCause(event.getResult().getError());
            } else {
                this.testResults.addTestResult(new TestResult(event.getTestCase().getId(), event.getTestCase().getName(), CucumberUtils.extractFeatureFileName(event.getTestCase().getUri().toString()) + ":" + event.getTestCase().getLine(), event.getResult().getError()));
            }
        }
        if (event.getResult().getStatus().is(Status.PENDING) || event.getResult().getStatus().is(Status.UNDEFINED)) {
            PendingException cause = new PendingException("The scenario has pending or undefined step(s)");
            if (testDetail.isPresent()) {
                testDetail.get().setCause((Throwable)cause);
            } else {
                this.testResults.addTestResult(new TestResult(event.getTestCase().getId(), event.getTestCase().getName(), CucumberUtils.extractFeatureFileName(event.getTestCase().getUri().toString()) + ":" + event.getTestCase().getLine(), (Throwable)cause));
            }
        }
    }

    private void setSuiteName(TestSourceRead event) {
        Matcher featureNameMatcher = this.featureNamePattern.matcher(event.getSource());
        if (featureNameMatcher.find()) {
            this.testResults.setSuiteName(featureNameMatcher.group(1).trim());
        } else if (event.getUri().getSchemeSpecificPart() != null) {
            this.testResults.setSuiteName(event.getUri().getSchemeSpecificPart());
        }
    }

    private void printReports(TestRunFinished event) {
        try (BufferedWriter terminationLogWriter = Files.newBufferedWriter(TestReporter.getTerminationLog(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            terminationLogWriter.write(this.testResults.toJson());
            ((Writer)terminationLogWriter).flush();
        }
        catch (IOException e) {
            LOG.warn(String.format("Failed to write termination logs to file '%s'", TestReporter.getTerminationLog()), (Throwable)e);
        }
    }

    private void saveTestResult(TestCaseFinished event) {
        switch (event.getResult().getStatus()) {
            case FAILED: {
                ++this.testResults.getSummary().failed;
                break;
            }
            case PASSED: {
                ++this.testResults.getSummary().passed;
                break;
            }
            case PENDING: {
                ++this.testResults.getSummary().pending;
                break;
            }
            case UNDEFINED: {
                ++this.testResults.getSummary().undefined;
                break;
            }
            case SKIPPED: {
                ++this.testResults.getSummary().skipped;
                break;
            }
        }
    }

    public static Path getTerminationLog() {
        return Paths.get(System.getProperty(TERMINATION_LOG_PROPERTY, System.getenv(TERMINATION_LOG_ENV) != null ? System.getenv(TERMINATION_LOG_ENV) : TERMINATION_LOG_DEFAULT), new String[0]);
    }
}

