/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.standard;

import com.consol.citrus.Citrus;
import com.consol.citrus.CitrusSettings;
import com.consol.citrus.TestActionBuilder;
import com.consol.citrus.TestCaseRunner;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.actions.SendMessageAction;
import com.consol.citrus.annotations.CitrusFramework;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.message.DefaultMessage;
import com.consol.citrus.message.Message;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.yaks.message.MessageCreator;
import org.citrusframework.yaks.message.MessageCreators;

public class MessagingSteps {
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusFramework
    private Citrus citrus;
    private MessageCreators messageCreators;
    private Map<String, Message> messages;

    @Before
    public void before() {
        this.messageCreators = new MessageCreators();
        this.citrus.getCitrusContext().getReferenceResolver().resolveAll(MessageCreator.class).forEach(this.messageCreators::add);
        this.messages = new HashMap<String, Message>();
    }

    @Given(value="^message creator type ([^\\s]+)$")
    public void messageCreator(String type) {
        this.messageCreators.addType(type);
    }

    @Given(value="^message creator types$")
    public void messageCreators(DataTable types) {
        types.asList().forEach(this.messageCreators::addType);
    }

    @Given(value="^(?:create|new) message ([^\\s]+)$")
    public void message(String messageId) {
        this.messages.put(messageId, (Message)new DefaultMessage());
    }

    @When(value="^endpoint ([^\\s]+) sends message \\$([^\\s]+)$")
    @Then(value="^endpoint ([^\\s]+) should send message \\$([^\\s]+)$")
    public void sendMessage(String endpoint, String messageId) {
        if (this.messages.containsKey(messageId)) {
            this.runner.when((TestActionBuilder)((SendMessageAction.Builder)SendMessageAction.Builder.send().endpoint(endpoint)).message((Message)new DefaultMessage(this.messages.get(messageId))));
        } else {
            Message message = this.messageCreators.createMessage(messageId);
            this.runner.when((TestActionBuilder)((SendMessageAction.Builder)SendMessageAction.Builder.send().endpoint(endpoint)).message(message));
        }
    }

    @When(value="^endpoint ([^\\s]+) sends body ([\\w\\W]+)$")
    @Then(value="^endpoint ([^\\s]+) should send body ([\\w\\W]+)$")
    public void sendBody(String endpoint, String body) {
        this.runner.when((TestActionBuilder)((SendMessageAction.SendMessageActionBuilderSupport)((SendMessageAction.Builder)SendMessageAction.Builder.send().endpoint(endpoint)).message()).body(body));
    }

    @When(value="^endpoint ([^\\s]+) sends body$")
    @Then(value="^endpoint ([^\\s]+) should send body$")
    public void sendMultilineBody(String endpoint, String body) {
        this.sendBody(endpoint, body);
    }

    @When(value="^endpoint ([^\\s]+) receives ([^\\s]+) message \\$([^\\s]+)$")
    @Then(value="^endpoint ([^\\s]+) should receive ([^\\s]+) message \\$([^\\s]+)$")
    public void receiveMessage(String endpoint, String type, String messageId) {
        if (this.messages.containsKey(messageId)) {
            this.runner.when((TestActionBuilder)((ReceiveMessageAction.Builder)ReceiveMessageAction.Builder.receive().endpoint(endpoint)).message((Message)new DefaultMessage(this.messages.get(messageId)).setType(type)));
        } else {
            Message message = this.messageCreators.createMessage(messageId);
            this.runner.when((TestActionBuilder)((ReceiveMessageAction.ReceiveMessageActionBuilderSupport)((ReceiveMessageAction.Builder)ReceiveMessageAction.Builder.receive().endpoint(endpoint)).message(message)).type(type));
        }
    }

    @When(value="^endpoint ([^\\s]+) receives message \\$([^\\s]+)$")
    @Then(value="^endpoint ([^\\s]+) should receive message \\$([^\\s]+)$")
    public void receiveMessage(String endpoint, String messageName) {
        this.receiveMessage(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, messageName);
    }

    @When(value="^endpoint ([^\\s]+) receives ([^\\s]+) body ([\\w\\W]+)$")
    @Then(value="^endpoint ([^\\s]+) should receive ([^\\s]+) body ([\\w\\W]+)$")
    public void receiveBody(String endpoint, String type, String body) {
        this.runner.when((TestActionBuilder)((ReceiveMessageAction.ReceiveMessageActionBuilderSupport)((ReceiveMessageAction.ReceiveMessageActionBuilderSupport)((ReceiveMessageAction.Builder)ReceiveMessageAction.Builder.receive().endpoint(endpoint)).message()).type(type)).body(body));
    }

    @When(value="^endpoint ([^\\s]+) receives body ([\\w\\W]+)$")
    @Then(value="^endpoint ([^\\s]+) should receive body ([\\w\\W]+)$")
    public void receiveDefault(String endpoint, String body) {
        this.receiveBody(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, body);
    }

    @When(value="^endpoint ([^\\s]+) receives body$")
    @Then(value="^endpoint ([^\\s]+) should receive body$")
    public void receiveMultilineBody(String endpoint, String body) {
        this.receiveBody(endpoint, CitrusSettings.DEFAULT_MESSAGE_TYPE, body);
    }

    @When(value="^endpoint ([^\\s]+) receives ([^\\s]+) body$")
    @Then(value="^endpoint ([^\\s]+) should receive ([^\\s]+) body$")
    public void shouldReceiveMultiline(String endpoint, String type, String body) {
        this.receiveBody(endpoint, type, body);
    }

    @And(value="^\\$([^\\s]+) header ([^\\s]+)(?: is |=)\"([^\"]*)\"$")
    public void addHeader(String messageId, String name, String value) {
        this.messages.get(messageId).setHeader(name, (Object)value);
    }

    @And(value="^\\$([^\\s]+) has body ([\\w\\W]+)$")
    public void addBody(String messageId, String body) {
        this.messages.get(messageId).setPayload((Object)body);
    }

    @And(value="^\\$([^\\s]+) has body$")
    public void addBodyMultiline(String messageId, String body) {
        this.addBody(messageId, body);
    }
}

