/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

import io.cucumber.java.en.Given;
import java.io.IOException;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseContainerSteps {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseContainerSteps.class);
    @CitrusResource
    private TestContext context;

    @Given(value="^(?:D|d)atabase init script$")
    public void setInitScript(String initScript) {
        DatabaseContainerSteps.saveInitScript(this.context, initScript);
    }

    @Given(value="^load database init script (^\\s+)$")
    public void loadInitScript(String file) throws IOException {
        DatabaseContainerSteps.saveInitScript(this.context, FileUtils.readToString((Resource)FileUtils.getFileResource((String)this.context.replaceDynamicContentInString(file))));
    }

    protected static void saveInitScript(TestContext context, String initScript) {
        context.setVariable("YAKS_TESTCONTAINERS_DB_INIT_SCRIPT", (Object)initScript);
    }

    protected static String getInitScript(TestContext context) {
        try {
            return context.getVariable("YAKS_TESTCONTAINERS_DB_INIT_SCRIPT");
        }
        catch (CitrusRuntimeException e) {
            LOG.debug("Missing database init script", (Throwable)e);
            return "";
        }
    }
}

