/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

public class KafkaSettings {
    private static final String KAFKA_PROPERTY_PREFIX = "yaks.testcontainers.kafka.";
    private static final String KAFKA_ENV_PREFIX = "YAKS_TESTCONTAINERS_KAFKA_";
    private static final String KAFKA_VERSION_PROPERTY = "yaks.testcontainers.kafka.version";
    private static final String KAFKA_VERSION_ENV = "YAKS_TESTCONTAINERS_KAFKA_KAFKA_VERSION";
    private static final String KAFKA_VERSION_DEFAULT = "7.5.1";
    private static final String KAFKA_SERVICE_NAME_PROPERTY = "yaks.testcontainers.kafka.service.name";
    private static final String KAFKA_SERVICE_NAME_ENV = "YAKS_TESTCONTAINERS_KAFKA_KAFKA_SERVICE_NAME";
    private static final String KAFKA_SERVICE_NAME_DEFAULT = "yaks-kafka";
    private static final String KAFKA_IMAGE_NAME_PROPERTY = "yaks.testcontainers.kafka.image.name";
    private static final String KAFKA_IMAGE_NAME_ENV = "YAKS_TESTCONTAINERS_KAFKA_KAFKA_IMAGE_NAME";
    private static final String KAFKA_IMAGE_NAME_DEFAULT = "confluentinc/cp-kafka";
    private static final String STARTUP_TIMEOUT_PROPERTY = "yaks.testcontainers.kafka.startup.timeout";
    private static final String STARTUP_TIMEOUT_ENV = "YAKS_TESTCONTAINERS_KAFKA_STARTUP_TIMEOUT";
    private static final String STARTUP_TIMEOUT_DEFAULT = "180";

    private KafkaSettings() {
    }

    public static String getImageName() {
        return System.getProperty(KAFKA_IMAGE_NAME_PROPERTY, System.getenv(KAFKA_IMAGE_NAME_ENV) != null ? System.getenv(KAFKA_IMAGE_NAME_ENV) : KAFKA_IMAGE_NAME_DEFAULT);
    }

    public static String getVersion() {
        return System.getProperty(KAFKA_VERSION_PROPERTY, System.getenv(KAFKA_VERSION_ENV) != null ? System.getenv(KAFKA_VERSION_ENV) : KAFKA_VERSION_DEFAULT);
    }

    public static String getServiceName() {
        return System.getProperty(KAFKA_SERVICE_NAME_PROPERTY, System.getenv(KAFKA_SERVICE_NAME_ENV) != null ? System.getenv(KAFKA_SERVICE_NAME_ENV) : KAFKA_SERVICE_NAME_DEFAULT);
    }

    public static int getStartupTimeout() {
        return Integer.parseInt(System.getProperty(STARTUP_TIMEOUT_PROPERTY, System.getenv(STARTUP_TIMEOUT_ENV) != null ? System.getenv(STARTUP_TIMEOUT_ENV) : STARTUP_TIMEOUT_DEFAULT));
    }
}

