/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

public class MongoDBSettings {
    private static final String MONGODB_PROPERTY_PREFIX = "yaks.testcontainers.mongodb.";
    private static final String MONGODB_ENV_PREFIX = "YAKS_TESTCONTAINERS_MONGODB_";
    private static final String VERSION_PROPERTY = "yaks.testcontainers.mongodb.version";
    private static final String VERSION_ENV = "YAKS_TESTCONTAINERS_MONGODB_VERSION";
    private static final String VERSION_DEFAULT = "4.0.10";
    private static final String SERVICE_NAME_PROPERTY = "yaks.testcontainers.mongodb.service.name";
    private static final String SERVICE_NAME_ENV = "YAKS_TESTCONTAINERS_MONGODB_SERVICE_NAME";
    private static final String SERVICE_NAME_DEFAULT = "yaks-mongodb";
    private static final String STARTUP_TIMEOUT_PROPERTY = "yaks.testcontainers.mongodb.startup.timeout";
    private static final String STARTUP_TIMEOUT_ENV = "YAKS_TESTCONTAINERS_MONGODB_STARTUP_TIMEOUT";
    private static final String STARTUP_TIMEOUT_DEFAULT = "180";

    private MongoDBSettings() {
    }

    public static String getMongoDBVersion() {
        return System.getProperty(VERSION_PROPERTY, System.getenv(VERSION_ENV) != null ? System.getenv(VERSION_ENV) : VERSION_DEFAULT);
    }

    public static String getServiceName() {
        return System.getProperty(SERVICE_NAME_PROPERTY, System.getenv(SERVICE_NAME_ENV) != null ? System.getenv(SERVICE_NAME_ENV) : SERVICE_NAME_DEFAULT);
    }

    public static int getStartupTimeout() {
        return Integer.parseInt(System.getProperty(STARTUP_TIMEOUT_PROPERTY, System.getenv(STARTUP_TIMEOUT_ENV) != null ? System.getenv(STARTUP_TIMEOUT_ENV) : STARTUP_TIMEOUT_DEFAULT));
    }
}

