/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.apache.commons.dbcp2.BasicDataSource;
import org.citrusframework.Citrus;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.testcontainers.DatabaseContainerSteps;
import org.citrusframework.yaks.testcontainers.PostgreSQLSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSteps;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;
import org.testcontainers.jdbc.JdbcDatabaseDelegate;
import org.testcontainers.utility.DockerImageName;

public class PostgreSQLSteps {
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    private String postgreSQLVersion = PostgreSQLSettings.getPostgreSQLVersion();
    private PostgreSQLContainer<?> postgreSQLContainer;
    private String databaseName = PostgreSQLSettings.getDatabaseName();
    private String username = PostgreSQLSettings.getUsername();
    private String password = PostgreSQLSettings.getPassword();
    private int startupTimeout = PostgreSQLSettings.getStartupTimeout();
    private Map<String, String> env = new HashMap<String, String>();
    private String serviceName = PostgreSQLSettings.getServiceName();

    @Before
    public void before(Scenario scenario) {
        if (this.postgreSQLContainer == null && this.citrus.getCitrusContext().getReferenceResolver().isResolvable(PostgreSQLContainer.class)) {
            this.postgreSQLContainer = (PostgreSQLContainer)this.citrus.getCitrusContext().getReferenceResolver().resolve("postgreSQLContainer", PostgreSQLContainer.class);
            this.setConnectionSettings(this.postgreSQLContainer, this.context);
        }
    }

    @Given(value="^PostgreSQL version (^\\s+)$")
    public void setPostgreSQLVersion(String version) {
        this.postgreSQLVersion = version;
    }

    @Given(value="^PostgreSQL service name (^\\s+)$")
    public void setPostgreSQLServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Given(value="^PostgreSQL startup timeout is (\\d+)(?: s| seconds)$")
    public void setStartupTimeout(int timeout) {
        this.startupTimeout = timeout;
    }

    @Given(value="^PostgreSQL database name (^\\s+)$")
    public void setDatabaseName(String name) {
        this.databaseName = name;
    }

    @Given(value="^PostgreSQL username (^\\s+)$")
    public void setUsername(String name) {
        this.username = name;
    }

    @Given(value="^PostgreSQL password (^\\s+)$")
    public void setPassword(String password) {
        this.password = password;
    }

    @Given(value="^PostgreSQL env settings$")
    public void setEnvSettings(DataTable settings) {
        this.env.putAll(settings.asMap());
    }

    @Given(value="^start PostgreSQL container$")
    public void startPostgresql() {
        this.env.putIfAbsent("PGDATA", "/var/lib/postgresql/data/mydata");
        this.postgreSQLContainer = (PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)((PostgreSQLContainer)new PostgreSQLContainer(DockerImageName.parse((String)"postgres").withTag(this.postgreSQLVersion)).withUsername(this.username).withPassword(this.password).withDatabaseName(this.databaseName).withLabel("app", "yaks")).withLabel("com.joyrex2001.kubedock.name-prefix", this.serviceName)).withLabel("app.kubernetes.io/name", "postgresql")).withLabel("app.kubernetes.io/part-of", TestContainersSettings.getTestName())).withLabel("app.openshift.io/connects-to", TestContainersSettings.getTestId())).withNetwork(Network.newNetwork())).withNetworkAliases(new String[]{this.serviceName})).withEnv(this.env)).waitingFor(Wait.forListeningPort().withStartupTimeout(Duration.of(this.startupTimeout, ChronoUnit.SECONDS)));
        this.postgreSQLContainer.start();
        String initScript = DatabaseContainerSteps.getInitScript(this.context);
        if (!initScript.isEmpty()) {
            try {
                ScriptUtils.executeDatabaseScript((DatabaseDelegate)new JdbcDatabaseDelegate(this.postgreSQLContainer, ""), (String)"init.sql", (String)initScript);
            }
            catch (ScriptException e) {
                throw new CitrusRuntimeException("Failed to execute init script");
            }
        }
        BasicDataSource postgreSQLDataSource = new BasicDataSource();
        postgreSQLDataSource.setDriverClassName(this.postgreSQLContainer.getDriverClassName());
        postgreSQLDataSource.setUrl(this.postgreSQLContainer.getJdbcUrl());
        postgreSQLDataSource.setUsername(this.postgreSQLContainer.getUsername());
        postgreSQLDataSource.setPassword(this.postgreSQLContainer.getPassword());
        this.citrus.getCitrusContext().bind("postgreSQL", (Object)postgreSQLDataSource);
        this.citrus.getCitrusContext().bind("postgreSQLContainer", this.postgreSQLContainer);
        this.setConnectionSettings(this.postgreSQLContainer, this.context);
        if (TestContainersSteps.autoRemoveResources) {
            this.runner.run((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestAction[]{context -> this.postgreSQLContainer.stop()}));
        }
    }

    @Given(value="^stop PostgreSQL container$")
    public void stopPostgresql() {
        if (this.postgreSQLContainer != null) {
            this.postgreSQLContainer.stop();
        }
        this.env = new HashMap<String, String>();
    }

    private void setConnectionSettings(PostgreSQLContainer<?> postgreSQLContainer, TestContext context) {
        if (!postgreSQLContainer.isRunning()) {
            return;
        }
        String containerId = postgreSQLContainer.getContainerId().substring(0, 12);
        String containerName = postgreSQLContainer.getContainerName();
        if (containerName.startsWith("/")) {
            containerName = containerName.substring(1);
        }
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_HOST", (Object)postgreSQLContainer.getHost());
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_CONTAINER_IP", (Object)postgreSQLContainer.getHost());
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_CONTAINER_ID", (Object)containerId);
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_CONTAINER_NAME", (Object)containerName);
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_SERVICE_PORT", (Object)String.valueOf(postgreSQLContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue())));
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_PORT", (Object)String.valueOf(postgreSQLContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue())));
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_USERNAME", (Object)postgreSQLContainer.getUsername());
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_PASSWORD", (Object)postgreSQLContainer.getPassword());
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_DRIVER", (Object)postgreSQLContainer.getDriverClassName());
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_DB_NAME", (Object)postgreSQLContainer.getDatabaseName());
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_SERVICE_LOCAL_URL", (Object)postgreSQLContainer.getJdbcUrl());
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_LOCAL_URL", (Object)postgreSQLContainer.getJdbcUrl());
        if (YaksSettings.isLocal() || !TestContainersSettings.isKubedockEnabled()) {
            context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_SERVICE_NAME", (Object)this.serviceName);
            context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_SERVICE_URL", (Object)postgreSQLContainer.getJdbcUrl());
            context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_URL", (Object)postgreSQLContainer.getJdbcUrl());
        } else {
            context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_SERVICE_NAME", (Object)this.serviceName);
            context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_SERVICE_URL", (Object)String.format("jdbc:postgresql://%s:%s/%s", this.serviceName, postgreSQLContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()), postgreSQLContainer.getDatabaseName()));
            context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_URL", (Object)String.format("jdbc:postgresql://%s:%s/%s", this.serviceName, postgreSQLContainer.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()), postgreSQLContainer.getDatabaseName()));
        }
        context.setVariable("YAKS_TESTCONTAINERS_POSTGRESQL_KUBE_DOCK_HOST", (Object)this.serviceName);
    }
}

