/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.Citrus;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.testcontainers.RedpandaSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSteps;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.redpanda.RedpandaContainer;
import org.testcontainers.utility.DockerImageName;

public class RedpandaSteps {
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    public static final int REDPANDA_PORT = 9092;
    private String redpandaVersion = RedpandaSettings.getVersion();
    private RedpandaContainer redpandaContainer;
    private int startupTimeout = RedpandaSettings.getStartupTimeout();
    private Map<String, String> env = new HashMap<String, String>();
    private String serviceName = RedpandaSettings.getServiceName();

    @Before
    public void before(Scenario scenario) {
        if (this.redpandaContainer == null && this.citrus.getCitrusContext().getReferenceResolver().isResolvable(RedpandaContainer.class)) {
            this.redpandaContainer = (RedpandaContainer)this.citrus.getCitrusContext().getReferenceResolver().resolve("redpandaContainer", RedpandaContainer.class);
            this.setConnectionSettings(this.redpandaContainer, this.context);
        }
    }

    @Given(value="^Redpanda version (^\\s+)$")
    public void setRedpandaVersion(String version) {
        this.redpandaVersion = version;
    }

    @Given(value="^Redpanda service name (^\\s+)$")
    public void setRedpandaServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Given(value="^Redpanda startup timeout is (\\d+)(?: s| seconds)$")
    public void setStartupTimeout(int timeout) {
        this.startupTimeout = timeout;
    }

    @Given(value="^Redpanda env settings$")
    public void setEnvSettings(DataTable settings) {
        this.env.putAll(settings.asMap());
    }

    @Given(value="^start Redpanda container$")
    public void startRedpanda() {
        this.redpandaContainer = (RedpandaContainer)((RedpandaContainer)((RedpandaContainer)((RedpandaContainer)((RedpandaContainer)((RedpandaContainer)((RedpandaContainer)((RedpandaContainer)((RedpandaContainer)new RedpandaContainer(DockerImageName.parse((String)RedpandaSettings.getImageName()).withTag(this.redpandaVersion)).withLabel("app", "yaks")).withLabel("com.joyrex2001.kubedock.name-prefix", this.serviceName)).withLabel("app.kubernetes.io/name", "redpanda")).withLabel("app.kubernetes.io/part-of", TestContainersSettings.getTestName())).withLabel("app.openshift.io/connects-to", TestContainersSettings.getTestId())).withNetwork(Network.newNetwork())).withNetworkAliases(new String[]{this.serviceName})).withEnv(this.env)).waitingFor(Wait.forLogMessage((String)".*Started Kafka API server.*", (int)1).withStartupTimeout(Duration.of(this.startupTimeout, ChronoUnit.SECONDS)));
        this.redpandaContainer.start();
        this.citrus.getCitrusContext().bind("redpandaContainer", (Object)this.redpandaContainer);
        this.setConnectionSettings(this.redpandaContainer, this.context);
        if (TestContainersSteps.autoRemoveResources) {
            this.runner.run((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestAction[]{context -> this.redpandaContainer.stop()}));
        }
    }

    @Given(value="^stop Redpanda container$")
    public void stopRedpanda() {
        if (this.redpandaContainer != null) {
            this.redpandaContainer.stop();
        }
        this.env = new HashMap<String, String>();
    }

    private void setConnectionSettings(RedpandaContainer redpandaContainer, TestContext context) {
        if (!redpandaContainer.isRunning()) {
            return;
        }
        String containerId = redpandaContainer.getContainerId().substring(0, 12);
        String containerName = redpandaContainer.getContainerName();
        if (containerName.startsWith("/")) {
            containerName = containerName.substring(1);
        }
        context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_HOST", (Object)redpandaContainer.getHost());
        context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_CONTAINER_IP", (Object)redpandaContainer.getHost());
        context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_CONTAINER_ID", (Object)containerId);
        context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_CONTAINER_NAME", (Object)containerName);
        context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_SERVICE_PORT", (Object)String.valueOf(redpandaContainer.getMappedPort(9092)));
        context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_PORT", (Object)String.valueOf(redpandaContainer.getMappedPort(9092)));
        context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_LOCAL_BOOTSTRAP_SERVERS", (Object)redpandaContainer.getBootstrapServers());
        if (YaksSettings.isLocal() || !TestContainersSettings.isKubedockEnabled()) {
            context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_SERVICE_NAME", (Object)this.serviceName);
            context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_BOOTSTRAP_SERVERS", (Object)redpandaContainer.getBootstrapServers());
        } else {
            context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_SERVICE_NAME", (Object)this.serviceName);
            context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_BOOTSTRAP_SERVERS", (Object)String.format("%s:%s", this.serviceName, redpandaContainer.getMappedPort(9092)));
        }
        context.setVariable("YAKS_TESTCONTAINERS_REDPANDA_KUBE_DOCK_HOST", (Object)this.serviceName);
    }
}

