/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.Citrus;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.testcontainers.KafkaSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSteps;
import org.testcontainers.containers.KafkaContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.DockerImageName;

public class KafkaSteps {
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    private String kafkaVersion = KafkaSettings.getVersion();
    private KafkaContainer kafkaContainer;
    private int startupTimeout = KafkaSettings.getStartupTimeout();
    private String serviceName = KafkaSettings.getServiceName();
    private Map<String, String> env = new HashMap<String, String>();

    @Before
    public void before(Scenario scenario) {
        if (this.kafkaContainer == null && this.citrus.getCitrusContext().getReferenceResolver().isResolvable(KafkaContainer.class)) {
            this.kafkaContainer = (KafkaContainer)this.citrus.getCitrusContext().getReferenceResolver().resolve("kafkaContainer", KafkaContainer.class);
            this.setConnectionSettings(this.kafkaContainer, this.context);
        }
    }

    @Given(value="^Kafka container version (^\\s+)$")
    public void setKafkaVersion(String version) {
        this.kafkaVersion = version;
    }

    @Given(value="^Kafka service name (^\\s+)$")
    public void setKafkaServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Given(value="^Kafka container startup timeout is (\\d+)(?: s| seconds)$")
    public void setStartupTimeout(int timeout) {
        this.startupTimeout = timeout;
    }

    @Given(value="^Kafka container env settings$")
    public void setEnvSettings(DataTable settings) {
        this.env.putAll(settings.asMap());
    }

    @Given(value="^start Kafka container$")
    public void startKafka() {
        this.kafkaContainer = (KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)((KafkaContainer)new KafkaContainer(DockerImageName.parse((String)KafkaSettings.getImageName()).withTag(this.kafkaVersion)).withLabel("app", "yaks")).withLabel("com.joyrex2001.kubedock.name-prefix", this.serviceName)).withLabel("app.kubernetes.io/name", "kafka")).withLabel("app.kubernetes.io/part-of", TestContainersSettings.getTestName())).withLabel("app.openshift.io/connects-to", TestContainersSettings.getTestId())).withNetwork(Network.newNetwork())).withNetworkAliases(new String[]{this.serviceName})).withEnv(this.env)).withStartupTimeout(Duration.of(this.startupTimeout, ChronoUnit.SECONDS));
        this.kafkaContainer.start();
        this.citrus.getCitrusContext().bind("kafkaContainer", (Object)this.kafkaContainer);
        this.setConnectionSettings(this.kafkaContainer, this.context);
        if (TestContainersSteps.autoRemoveResources) {
            this.runner.run((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestAction[]{context -> this.kafkaContainer.stop()}));
        }
    }

    @Given(value="^stop Kafka container$")
    public void stopKafka() {
        if (this.kafkaContainer != null) {
            this.kafkaContainer.stop();
        }
        this.env = new HashMap<String, String>();
    }

    private void setConnectionSettings(KafkaContainer kafkaContainer, TestContext context) {
        if (!kafkaContainer.isRunning()) {
            return;
        }
        String containerId = kafkaContainer.getContainerId().substring(0, 12);
        String containerName = kafkaContainer.getContainerName();
        if (containerName.startsWith("/")) {
            containerName = containerName.substring(1);
        }
        context.setVariable("YAKS_TESTCONTAINERS_KAFKA_HOST", (Object)kafkaContainer.getHost());
        context.setVariable("YAKS_TESTCONTAINERS_KAFKA_CONTAINER_IP", (Object)kafkaContainer.getHost());
        context.setVariable("YAKS_TESTCONTAINERS_KAFKA_CONTAINER_ID", (Object)containerId);
        context.setVariable("YAKS_TESTCONTAINERS_KAFKA_CONTAINER_NAME", (Object)containerName);
        context.setVariable("YAKS_TESTCONTAINERS_KAFKA_SERVICE_PORT", (Object)String.valueOf(kafkaContainer.getMappedPort(9093)));
        context.setVariable("YAKS_TESTCONTAINERS_KAFKA_PORT", (Object)String.valueOf(kafkaContainer.getMappedPort(9093)));
        context.setVariable("YAKS_TESTCONTAINERS_KAFKA_LOCAL_BOOTSTRAP_SERVERS", (Object)kafkaContainer.getBootstrapServers());
        if (YaksSettings.isLocal() || !TestContainersSettings.isKubedockEnabled()) {
            context.setVariable("YAKS_TESTCONTAINERS_KAFKA_SERVICE_NAME", (Object)this.serviceName);
            context.setVariable("YAKS_TESTCONTAINERS_KAFKA_BOOTSTRAP_SERVERS", (Object)kafkaContainer.getBootstrapServers());
        } else {
            context.setVariable("YAKS_TESTCONTAINERS_KAFKA_SERVICE_NAME", (Object)this.serviceName);
            context.setVariable("YAKS_TESTCONTAINERS_KAFKA_BOOTSTRAP_SERVERS", (Object)String.format("%s:%s", this.serviceName, kafkaContainer.getMappedPort(9093)));
        }
        context.setVariable("YAKS_TESTCONTAINERS_KAFKA_KUBE_DOCK_HOST", (Object)this.serviceName);
    }
}

