/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.citrusframework.Citrus;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.kubernetes.KubernetesSettings;
import org.citrusframework.yaks.kubernetes.KubernetesVariableNames;
import org.citrusframework.yaks.testcontainers.LocalStackSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSteps;
import org.citrusframework.yaks.testcontainers.aws2.AWS2Container;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;

public class LocalStackSteps {
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    private String localStackVersion = LocalStackSettings.getVersion();
    private int startupTimeout = LocalStackSettings.getStartupTimeout();
    private AWS2Container aws2Container;
    private final Set<AWS2Container.AWS2Service> services = new HashSet<AWS2Container.AWS2Service>();
    private Map<String, String> env = new HashMap<String, String>();
    private String serviceName = LocalStackSettings.getServiceName();

    @Before
    public void before(Scenario scenario) {
        if (this.aws2Container == null && this.citrus.getCitrusContext().getReferenceResolver().isResolvable(AWS2Container.class)) {
            this.aws2Container = (AWS2Container)((Object)this.citrus.getCitrusContext().getReferenceResolver().resolve("aws2Container", AWS2Container.class));
            this.services.addAll(Arrays.asList(this.aws2Container.getServices()));
            this.exposeConnectionSettings(this.aws2Container, this.context);
        }
    }

    @Given(value="^LocalStack version (^\\s+)$")
    public void setLocalStackVersion(String version) {
        this.localStackVersion = version;
    }

    @Given(value="^LocalStack service name (^\\s+)$")
    public void setLocalStackServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Given(value="^LocalStack env settings$")
    public void setEnvSettings(DataTable settings) {
        this.env.putAll(settings.asMap());
    }

    @Given(value="^LocalStack startup timeout is (\\d+)(?: s| seconds)$")
    public void setStartupTimeout(int timeout) {
        this.startupTimeout = timeout;
    }

    @Given(value="^Enable service (S3|KINESIS|SQS|SNS|DYNAMODB|DYNAMODB_STREAMS|IAM|API_GATEWAY|FIREHOSE|LAMBDA)$")
    public void enableService(String service) {
        this.services.add(AWS2Container.AWS2Service.valueOf(service));
    }

    @Given(value="^start LocalStack container$")
    public void startLocalStack() {
        this.aws2Container = (AWS2Container)((AWS2Container)((AWS2Container)((AWS2Container)((AWS2Container)((AWS2Container)((AWS2Container)((AWS2Container)((AWS2Container)new AWS2Container(this.localStackVersion, new AWS2Container.AWS2Service[0]).withServices((AWS2Container.AWS2Service[])this.services.toArray(AWS2Container.AWS2Service[]::new)).withLabel("app", "yaks")).withLabel("com.joyrex2001.kubedock.name-prefix", this.serviceName)).withLabel("app.kubernetes.io/name", "build")).withLabel("app.kubernetes.io/part-of", TestContainersSettings.getTestName())).withLabel("app.openshift.io/connects-to", TestContainersSettings.getTestId())).withNetwork(Network.newNetwork())).withNetworkAliases(new String[]{this.serviceName})).withEnv(this.env)).waitingFor(Wait.forListeningPort().withStartupTimeout(Duration.of(this.startupTimeout, ChronoUnit.SECONDS)));
        this.aws2Container.start();
        this.citrus.getCitrusContext().bind("aws2Container", (Object)this.aws2Container);
        this.exposeConnectionSettings(this.aws2Container, this.context);
        if (TestContainersSteps.autoRemoveResources) {
            this.runner.run((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestAction[]{context -> this.aws2Container.stop()}));
        }
    }

    @Given(value="^stop LocalStack container$")
    public void stopLocalStack() {
        if (this.aws2Container != null) {
            this.aws2Container.stop();
        }
        this.env = new HashMap<String, String>();
    }

    private void exposeConnectionSettings(AWS2Container aws2Container, TestContext context) {
        if (aws2Container.isRunning()) {
            URI serviceEndpoint = aws2Container.getServiceEndpoint();
            String containerId = aws2Container.getContainerId().substring(0, 12);
            String containerName = aws2Container.getContainerName();
            if (containerName.startsWith("/")) {
                containerName = containerName.substring(1);
            }
            context.setVariable(this.getEnvVarName("HOST"), (Object)aws2Container.getHost());
            context.setVariable(this.getEnvVarName("CONTAINER_IP"), (Object)aws2Container.getHost());
            context.setVariable(this.getEnvVarName("CONTAINER_ID"), (Object)containerId);
            context.setVariable(this.getEnvVarName("CONTAINER_NAME"), (Object)containerName);
            context.setVariable(this.getEnvVarName("REGION"), (Object)aws2Container.getRegion());
            context.setVariable(this.getEnvVarName("ACCESS_KEY"), (Object)aws2Container.getAccessKey());
            context.setVariable(this.getEnvVarName("SECRET_KEY"), (Object)aws2Container.getSecretKey());
            context.setVariable(this.getEnvVarName("SERVICE_PORT"), (Object)serviceEndpoint.getPort());
            context.setVariable(this.getEnvVarName("SERVICE_LOCAL_URL"), (Object)String.format("http://localhost:%s", serviceEndpoint.getPort()));
            if (YaksSettings.isLocal() || !TestContainersSettings.isKubedockEnabled()) {
                context.setVariable(this.getEnvVarName("SERVICE_NAME"), (Object)this.serviceName);
                context.setVariable(this.getEnvVarName("SERVICE_URL"), (Object)String.format("http://localhost:%s", serviceEndpoint.getPort()));
            } else {
                context.setVariable(this.getEnvVarName("SERVICE_NAME"), (Object)this.serviceName);
                context.setVariable(this.getEnvVarName("SERVICE_URL"), (Object)String.format("http://%s:%s", this.serviceName, serviceEndpoint.getPort()));
            }
            this.services.forEach(service -> {
                String aws2ServiceName = service.getServiceName().toUpperCase(Locale.US);
                if (YaksSettings.isLocal() || !TestContainersSettings.isKubedockEnabled()) {
                    context.setVariable(this.getEnvVarName(String.format("%s_URL", aws2ServiceName)), (Object)String.format("http://localhost:%s", serviceEndpoint.getPort()));
                } else {
                    context.setVariable(this.getEnvVarName(String.format("%s_URL", aws2ServiceName)), (Object)String.format("http://%s:%s", this.serviceName, serviceEndpoint.getPort()));
                }
                context.setVariable(this.getEnvVarName(String.format("%s_LOCAL_URL", aws2ServiceName)), (Object)String.format("http://localhost:%s", serviceEndpoint.getPort()));
                context.setVariable(this.getEnvVarName(String.format("%s_PORT", aws2ServiceName)), (Object)serviceEndpoint.getPort());
            });
            context.setVariable(this.getEnvVarName("KUBE_DOCK_SERVICE_URL"), (Object)String.format("http://%s:%s", this.serviceName, serviceEndpoint.getPort()));
            context.setVariable(this.getEnvVarName("KUBE_DOCK_HOST"), (Object)this.serviceName);
            for (Map.Entry<Object, Object> connectionProperty : aws2Container.getConnectionProperties().entrySet()) {
                context.setVariable(connectionProperty.getKey().toString(), (Object)connectionProperty.getValue().toString());
            }
        }
    }

    private String getEnvVarName(String variable) {
        return String.format("%sLOCALSTACK_%s", "YAKS_TESTCONTAINERS_", variable);
    }

    private String getNamespace(TestContext context) {
        if (context.getVariables().containsKey(KubernetesVariableNames.NAMESPACE.value())) {
            return context.getVariable(KubernetesVariableNames.NAMESPACE.value());
        }
        return KubernetesSettings.getNamespace();
    }
}

