/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

import io.cucumber.datatable.DataTable;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import org.citrusframework.Citrus;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.container.FinallySequence;
import org.citrusframework.context.TestContext;
import org.citrusframework.yaks.YaksSettings;
import org.citrusframework.yaks.testcontainers.MongoDBSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSettings;
import org.citrusframework.yaks.testcontainers.TestContainersSteps;
import org.testcontainers.containers.MongoDBContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.utility.DockerImageName;

public class MongoDBSteps {
    @CitrusFramework
    private Citrus citrus;
    @CitrusResource
    private TestCaseRunner runner;
    @CitrusResource
    private TestContext context;
    private String mongoDBVersion = MongoDBSettings.getMongoDBVersion();
    private int startupTimeout = MongoDBSettings.getStartupTimeout();
    private MongoDBContainer mongoDBContainer;
    private Map<String, String> env = new HashMap<String, String>();
    private String serviceName = MongoDBSettings.getServiceName();

    @Before
    public void before(Scenario scenario) {
        if (this.mongoDBContainer == null && this.citrus.getCitrusContext().getReferenceResolver().isResolvable(MongoDBContainer.class)) {
            this.mongoDBContainer = (MongoDBContainer)this.citrus.getCitrusContext().getReferenceResolver().resolve("mongoDBContainer", MongoDBContainer.class);
            this.setConnectionSettings(this.mongoDBContainer, this.context);
        }
    }

    @Given(value="^MongoDB version (^\\s+)$")
    public void setMongoDBVersion(String version) {
        this.mongoDBVersion = version;
    }

    @Given(value="^MongoDB service name (^\\s+)$")
    public void setMongoDBServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Given(value="^MongoDB startup timeout is (\\d+)(?: s| seconds)$")
    public void setStartupTimeout(int timeout) {
        this.startupTimeout = timeout;
    }

    @Given(value="^MongoDB env settings$")
    public void setEnvSettings(DataTable settings) {
        this.env.putAll(settings.asMap());
    }

    @Given(value="^start MongoDB container$")
    public void startMongo() {
        this.mongoDBContainer = (MongoDBContainer)((MongoDBContainer)((MongoDBContainer)((MongoDBContainer)((MongoDBContainer)((MongoDBContainer)((MongoDBContainer)((MongoDBContainer)((MongoDBContainer)new MongoDBContainer(DockerImageName.parse((String)"mongo").withTag(this.mongoDBVersion)).withLabel("app", "yaks")).withLabel("com.joyrex2001.kubedock.name-prefix", this.serviceName)).withLabel("app.kubernetes.io/name", "mongodb")).withLabel("app.kubernetes.io/part-of", TestContainersSettings.getTestName())).withLabel("app.openshift.io/connects-to", TestContainersSettings.getTestId())).withNetwork(Network.newNetwork())).withNetworkAliases(new String[]{this.serviceName})).withEnv(this.env)).waitingFor(Wait.forLogMessage((String)"(?i).*waiting for connections.*", (int)1).withStartupTimeout(Duration.of(this.startupTimeout, ChronoUnit.SECONDS)));
        this.mongoDBContainer.start();
        this.citrus.getCitrusContext().bind("mongoDBContainer", (Object)this.mongoDBContainer);
        this.setConnectionSettings(this.mongoDBContainer, this.context);
        if (TestContainersSteps.autoRemoveResources) {
            this.runner.run((TestActionBuilder)FinallySequence.Builder.doFinally().actions(new TestAction[]{context -> this.mongoDBContainer.stop()}));
        }
    }

    @Given(value="^stop MongoDB container$")
    public void stopMongo() {
        if (this.mongoDBContainer != null) {
            this.mongoDBContainer.stop();
        }
        this.env = new HashMap<String, String>();
    }

    private void setConnectionSettings(MongoDBContainer mongoDBContainer, TestContext context) {
        if (mongoDBContainer.isRunning()) {
            String containerId = mongoDBContainer.getContainerId().substring(0, 12);
            String containerName = mongoDBContainer.getContainerName();
            if (containerName.startsWith("/")) {
                containerName = containerName.substring(1);
            }
            context.setVariable("YAKS_TESTCONTAINERS_MONGODB_CONTAINER_IP", (Object)mongoDBContainer.getHost());
            context.setVariable("YAKS_TESTCONTAINERS_MONGODB_CONTAINER_ID", (Object)containerId);
            context.setVariable("YAKS_TESTCONTAINERS_MONGODB_CONTAINER_NAME", (Object)containerName);
            context.setVariable("YAKS_TESTCONTAINERS_MONGODB_SERVICE_PORT", (Object)mongoDBContainer.getMappedPort(27017));
            context.setVariable("YAKS_TESTCONTAINERS_MONGODB_SERVICE_LOCAL_URL", (Object)mongoDBContainer.getReplicaSetUrl());
            context.setVariable("YAKS_TESTCONTAINERS_MONGODB_LOCAL_URL", (Object)mongoDBContainer.getReplicaSetUrl());
            if (YaksSettings.isLocal() || !TestContainersSettings.isKubedockEnabled()) {
                context.setVariable("YAKS_TESTCONTAINERS_MONGODB_SERVICE_NAME", (Object)this.serviceName);
                context.setVariable("YAKS_TESTCONTAINERS_MONGODB_SERVICE_URL", (Object)mongoDBContainer.getReplicaSetUrl());
                context.setVariable("YAKS_TESTCONTAINERS_MONGODB_URL", (Object)mongoDBContainer.getReplicaSetUrl());
            } else {
                context.setVariable("YAKS_TESTCONTAINERS_MONGODB_SERVICE_NAME", (Object)this.serviceName);
                context.setVariable("YAKS_TESTCONTAINERS_MONGODB_SERVICE_URL", (Object)String.format("mongodb://%s:%d/test", this.serviceName, mongoDBContainer.getMappedPort(27017)));
                context.setVariable("YAKS_TESTCONTAINERS_MONGODB_URL", (Object)String.format("mongodb://%s:%d/test", this.serviceName, mongoDBContainer.getMappedPort(27017)));
            }
            context.setVariable("YAKS_TESTCONTAINERS_MONGODB_KUBE_DOCK_HOST", (Object)this.serviceName);
        }
    }
}

