/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

public class PostgreSQLSettings {
    private static final String POSTGRESQL_PROPERTY_PREFIX = "yaks.testcontainers.postgresql.";
    private static final String POSTGRESQL_ENV_PREFIX = "YAKS_TESTCONTAINERS_POSTGRESQL_";
    private static final String POSTGRESQL_VERSION_PROPERTY = "yaks.testcontainers.postgresql.version";
    private static final String POSTGRESQL_VERSION_ENV = "YAKS_TESTCONTAINERS_POSTGRESQL_POSTGRESQL_VERSION";
    private static final String POSTGRESQL_VERSION_DEFAULT = "9.6.12";
    private static final String SERVICE_NAME_PROPERTY = "yaks.testcontainers.postgresql.service.name";
    private static final String SERVICE_NAME_ENV = "YAKS_TESTCONTAINERS_POSTGRESQL_SERVICE_NAME";
    private static final String SERVICE_NAME_DEFAULT = "yaks-postgresql";
    private static final String DATABASE_NAME_PROPERTY = "yaks.testcontainers.postgresql.db.name";
    private static final String DATABASE_NAME_ENV = "YAKS_TESTCONTAINERS_POSTGRESQL_DB_NAME";
    private static final String DATABASE_NAME_DEFAULT = "test";
    private static final String USERNAME_PROPERTY = "yaks.testcontainers.postgresql.username";
    private static final String USERNAME_ENV = "YAKS_TESTCONTAINERS_POSTGRESQL_USERNAME";
    private static final String USERNAME_DEFAULT = "test";
    private static final String PASSWORD_PROPERTY = "yaks.testcontainers.postgresql.password";
    private static final String PASSWORD_ENV = "YAKS_TESTCONTAINERS_POSTGRESQL_PASSWORD";
    private static final String PASSWORD_DEFAULT = "test";
    private static final String STARTUP_TIMEOUT_PROPERTY = "yaks.testcontainers.postgresql.startup.timeout";
    private static final String STARTUP_TIMEOUT_ENV = "YAKS_TESTCONTAINERS_POSTGRESQL_STARTUP_TIMEOUT";
    private static final String STARTUP_TIMEOUT_DEFAULT = "180";

    private PostgreSQLSettings() {
    }

    public static String getServiceName() {
        return System.getProperty(SERVICE_NAME_PROPERTY, System.getenv(SERVICE_NAME_ENV) != null ? System.getenv(SERVICE_NAME_ENV) : SERVICE_NAME_DEFAULT);
    }

    public static String getDatabaseName() {
        return System.getProperty(DATABASE_NAME_PROPERTY, System.getenv(DATABASE_NAME_ENV) != null ? System.getenv(DATABASE_NAME_ENV) : "test");
    }

    public static String getUsername() {
        return System.getProperty(USERNAME_PROPERTY, System.getenv(USERNAME_ENV) != null ? System.getenv(USERNAME_ENV) : "test");
    }

    public static String getPassword() {
        return System.getProperty(PASSWORD_PROPERTY, System.getenv(PASSWORD_ENV) != null ? System.getenv(PASSWORD_ENV) : "test");
    }

    public static String getPostgreSQLVersion() {
        return System.getProperty(POSTGRESQL_VERSION_PROPERTY, System.getenv(POSTGRESQL_VERSION_ENV) != null ? System.getenv(POSTGRESQL_VERSION_ENV) : POSTGRESQL_VERSION_DEFAULT);
    }

    public static int getStartupTimeout() {
        return Integer.parseInt(System.getProperty(STARTUP_TIMEOUT_PROPERTY, System.getenv(STARTUP_TIMEOUT_ENV) != null ? System.getenv(STARTUP_TIMEOUT_ENV) : STARTUP_TIMEOUT_DEFAULT));
    }
}

