/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers;

import java.util.Optional;
import org.citrusframework.yaks.YaksSettings;

public class TestContainersSettings {
    static final String TESTCONTAINERS_PROPERTY_PREFIX = "yaks.testcontainers.";
    static final String TESTCONTAINERS_ENV_PREFIX = "YAKS_TESTCONTAINERS_";
    private static final String AUTO_REMOVE_RESOURCES_PROPERTY = "yaks.testcontainers.auto.remove.resources";
    private static final String AUTO_REMOVE_RESOURCES_ENV = "YAKS_TESTCONTAINERS_AUTO_REMOVE_RESOURCES";
    private static final String AUTO_REMOVE_RESOURCES_DEFAULT = "true";
    private static final String KUBEDOCK_ENABLED_PROPERTY = "yaks.testcontainers.kubedock.enabled";
    private static final String KUBEDOCK_ENABLED_ENV = "YAKS_TESTCONTAINERS_KUBEDOCK_ENABLED";
    private static final String TEST_ID_PROPERTY = "yaks.test.id";
    private static final String TEST_ID_ENV = "YAKS_TEST_ID";
    private static final String TEST_ID_DEFAULT = "yaks-test";
    private static final String TEST_NAME_PROPERTY = "yaks.test.name";
    private static final String TEST_NAME_ENV = "YAKS_TEST_NAME";
    private static final String TEST_NAME_DEFAULT = "yaks";

    private TestContainersSettings() {
    }

    public static boolean isAutoRemoveResources() {
        return Boolean.parseBoolean(System.getProperty(AUTO_REMOVE_RESOURCES_PROPERTY, System.getenv(AUTO_REMOVE_RESOURCES_ENV) != null ? System.getenv(AUTO_REMOVE_RESOURCES_ENV) : AUTO_REMOVE_RESOURCES_DEFAULT));
    }

    public static boolean isKubedockEnabled() {
        return Boolean.parseBoolean(System.getProperty(KUBEDOCK_ENABLED_PROPERTY, Optional.ofNullable(System.getenv(KUBEDOCK_ENABLED_ENV)).orElseGet(() -> String.valueOf(!YaksSettings.isLocal()))));
    }

    public static String getTestId() {
        return System.getProperty(TEST_ID_PROPERTY, Optional.ofNullable(System.getenv(TEST_ID_ENV)).orElse(TEST_ID_DEFAULT));
    }

    public static String getTestName() {
        return System.getProperty(TEST_NAME_PROPERTY, Optional.ofNullable(System.getenv(TEST_NAME_ENV)).orElse(TEST_NAME_DEFAULT));
    }
}

