/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.yaks.testcontainers.aws2;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class AWS2Container
extends GenericContainer<AWS2Container> {
    private static final int PORT = 4566;
    private static final String HOSTNAME_EXTERNAL_ENV = "HOSTNAME_EXTERNAL";
    private static final String DOCKER_IMAGE_NAME = "localstack/localstack";
    private static final String DOCKER_IMAGE_TAG = "3.3.0";
    private final Set<AWS2Service> services = new HashSet<AWS2Service>();
    private String secretKey = "secretkey";
    private String accessKey = "accesskey";
    private String region = Region.US_EAST_1.id();

    public AWS2Container() {
        this(DOCKER_IMAGE_TAG, new AWS2Service[0]);
    }

    public AWS2Container(String version, AWS2Service ... services) {
        super(DockerImageName.parse((String)DOCKER_IMAGE_NAME).withTag(version));
        this.withServices(services);
        this.withExposedPorts(new Integer[]{4566});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready\\.\n", (int)1));
    }

    public AWS2Container withServices(AWS2Service ... services) {
        this.services.addAll(Arrays.asList(services));
        return (AWS2Container)this.self();
    }

    protected void configure() {
        String hostnameExternalReason;
        super.configure();
        if (this.services.isEmpty()) {
            throw new CitrusRuntimeException("Must provide at least one service");
        }
        this.withEnv("SERVICE", this.services.stream().map(AWS2Service::serviceName).collect(Collectors.joining(",")));
        if (this.getEnvMap().containsKey(HOSTNAME_EXTERNAL_ENV)) {
            hostnameExternalReason = "explicitly as environment variable";
        } else if (this.getNetwork() != null && this.getNetworkAliases().size() >= 1) {
            this.withEnv(HOSTNAME_EXTERNAL_ENV, (String)this.getNetworkAliases().get(this.getNetworkAliases().size() - 1));
            hostnameExternalReason = "to match last network alias on container with non-default network";
        } else {
            this.withEnv(HOSTNAME_EXTERNAL_ENV, this.getHost());
            hostnameExternalReason = "to match host-routable address for container";
        }
        this.logger().info("{} environment variable set to {} ({})", new Object[]{HOSTNAME_EXTERNAL_ENV, this.getEnvMap().get(HOSTNAME_EXTERNAL_ENV), hostnameExternalReason});
    }

    public AWS2Container withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return (AWS2Container)this.self();
    }

    public AWS2Container withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return (AWS2Container)this.self();
    }

    public AWS2Container withRegion(String region) {
        this.region = region;
        return (AWS2Container)this.self();
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public AwsCredentialsProvider getCredentialsProvider() {
        return () -> AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey);
    }

    public Properties getConnectionProperties() {
        Properties properties = new Properties();
        AwsCredentials credentials = this.getCredentialsProvider().resolveCredentials();
        properties.put("aws.access.key", credentials.accessKeyId());
        properties.put("aws.secret.key", credentials.secretAccessKey());
        properties.put("aws.region", Region.US_EAST_1.toString());
        properties.put("aws.host", this.getHost() + ":" + this.getMappedPort(4566));
        properties.put("aws.protocol", "http");
        return properties;
    }

    public String getHostIpAddress() {
        try {
            return InetAddress.getByName(this.getHost()).getHostAddress();
        }
        catch (UnknownHostException e) {
            this.logger().warn("Unable to resolve host ip address: {}", (Object)e.getMessage());
            return this.getHost();
        }
    }

    public URI getServiceEndpoint() {
        try {
            return new URI("http://" + this.getHost() + ":" + this.getMappedPort(4566));
        }
        catch (URISyntaxException e) {
            throw new CitrusRuntimeException(String.format("Unable to determine the service endpoint: %s", e.getMessage()), (Throwable)e);
        }
    }

    public AWS2Service[] getServices() {
        return (AWS2Service[])this.services.toArray(AWS2Service[]::new);
    }

    public static enum AWS2Service {
        CLOUD_WATCH("cloudwatch"),
        DYNAMODB("dynamodb"),
        EC2("ec2"),
        EVENT_BRIDGE("eventbridge"),
        IAM("iam"),
        KINESIS("kinesis"),
        KMS("kms"),
        LAMBDA("lambda"),
        S3("s3"),
        SECRETS_MANAGER("secretsmanager"),
        SNS("sns"),
        SQS("sqs"),
        STS("sts");

        private final String serviceName;

        private AWS2Service(String serviceName) {
            this.serviceName = serviceName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public static String serviceName(AWS2Service service) {
            return service.serviceName;
        }
    }
}

