/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.extension.Extension;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.core.ade.ADEException;
import org.citygml4j.core.ade.ADELoader;

public class ExtensionLoader
extends ADELoader<Extension> {
    private final Map<String, Extension> extensions = new ConcurrentHashMap<String, Extension>();
    private final Map<CityJSONContext, Boolean> listeners = Collections.synchronizedMap(new WeakHashMap());

    public boolean hasExtensions() {
        return !this.extensions.isEmpty();
    }

    public List<Extension> getExtensions() {
        return new ArrayList<Extension>(this.extensions.values());
    }

    public List<Extension> getExtensions(CityJSONVersion version) {
        return this.extensions.values().stream().filter(v -> v.getCityJSONVersion() == version).collect(Collectors.toList());
    }

    public Extension getExtension(String name) {
        return this.extensions.get(name);
    }

    public Extension getExtension(String name, CityJSONVersion version) {
        Extension extension = this.extensions.get(name);
        return extension.getCityJSONVersion() == version ? extension : null;
    }

    public Set<String> getExtensionNames() {
        return new HashSet<String>(this.extensions.keySet());
    }

    protected void loadADE(Extension extension) throws ADEException {
        if (extension.getName() == null) {
            throw new ADEException("The name of extension " + extension.getClass().getName() + " must not be null.");
        }
        if (extension.getCityJSONVersion() == null) {
            throw new ADEException("The CityJSON version of extension " + extension.getClass().getName() + " must not be null.");
        }
        Extension current = this.extensions.get(extension.getName());
        if (current != null && current.getCityJSONVersion() == extension.getCityJSONVersion()) {
            throw new ADEException("An extension has already been registered for the name '" + extension.getName() + "' and the CityJSON version " + extension.getCityJSONVersion() + ".");
        }
        this.extensions.put(extension.getName(), extension);
        for (CityJSONContext listener : this.listeners.keySet()) {
            listener.loadExtension(extension);
        }
    }

    protected void unloadADE(Extension extension) throws ADEException {
        if (this.extensions.remove(extension.getName()) != null) {
            this.listeners.keySet().forEach(v -> v.unloadExtension(extension));
        }
    }

    void addListener(CityJSONContext context) {
        this.listeners.put(context, Boolean.TRUE);
    }
}

