/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.address;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.model.address.AddressType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.xmlobjects.xal.model.Country;
import org.xmlobjects.xal.model.types.CountryName;
import org.xmlobjects.xal.model.types.CountryNameType;
import org.xmlobjects.xal.model.types.NameType;

public class CountryAdapter
implements JsonObjectBuilder<Country>,
JsonObjectSerializer<Country> {
    @Override
    public Country createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new Country();
    }

    @Override
    public void buildObject(Country object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        String propertyName = AddressType.COUNTRY.toTypeName();
        for (CountryNameType type : CountryNameType.values()) {
            JsonNode value;
            JsonNode jsonNode = value = type == CountryNameType.NAME ? node.path(propertyName) : node.path(propertyName + type.toValue());
            if (!value.isTextual()) continue;
            CountryName name = new CountryName(value.asText());
            name.setNameType((NameType)(type == CountryNameType.NAME ? null : type));
            object.getNameElements().add(name);
        }
    }

    @Override
    public void writeObject(Country object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        if (object.isSetNameElements()) {
            String propertyName = AddressType.COUNTRY.toTypeName();
            for (CountryName name : object.getNameElements()) {
                if (name.getContent() == null) continue;
                if (name.getNameType() == null || name.getNameType() == CountryNameType.NAME) {
                    node.put(propertyName, name.getContent());
                    continue;
                }
                node.put(propertyName + ((CountryNameType)name.getNameType()).toValue(), name.getContent());
            }
        }
    }
}

