/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.appearance;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.appearance.Color;
import org.citygml4j.core.model.appearance.X3DMaterial;
import org.xmlobjects.gml.model.basictypes.Code;

public class X3DMaterialAdapter
implements JsonObjectBuilder<X3DMaterial>,
JsonObjectSerializer<X3DMaterial> {
    @Override
    public X3DMaterial createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new X3DMaterial();
    }

    @Override
    public void buildObject(X3DMaterial object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode isSmooth;
        JsonNode transparency;
        JsonNode shininess;
        JsonNode specularColor;
        JsonNode emissiveColor;
        JsonNode diffuseColor;
        JsonNode ambientIntensity;
        JsonNode name = node.path("name");
        if (name.isTextual()) {
            object.getNames().add(new Code(name.asText()));
        }
        if ((ambientIntensity = node.path("ambientIntensity")).isNumber()) {
            object.setAmbientIntensity(Double.valueOf(ambientIntensity.asDouble()));
        }
        if ((diffuseColor = node.path("diffuseColor")).isArray()) {
            object.setDiffuseColor(this.toColor((ArrayNode)diffuseColor, 0.8));
        }
        if ((emissiveColor = node.path("emissiveColor")).isArray()) {
            object.setEmissiveColor(this.toColor((ArrayNode)emissiveColor, 0.0));
        }
        if ((specularColor = node.path("specularColor")).isArray()) {
            object.setSpecularColor(this.toColor((ArrayNode)specularColor, 1.0));
        }
        if ((shininess = node.path("shininess")).isNumber()) {
            object.setShininess(Double.valueOf(shininess.asDouble()));
        }
        if ((transparency = node.path("transparency")).isNumber()) {
            object.setTransparency(Double.valueOf(transparency.asDouble()));
        }
        if ((isSmooth = node.path("isSmooth")).isBoolean()) {
            object.setIsSmooth(Boolean.valueOf(transparency.asBoolean()));
        }
    }

    @Override
    public void writeObject(X3DMaterial object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        String name = null;
        if (object.isSetNames()) {
            for (Code code : object.getNames()) {
                if (code.getValue() == null) continue;
                name = code.getValue();
                break;
            }
        }
        if (name == null) {
            name = object.getId() != null ? object.getId() : helper.getIdCreator().createId();
        }
        node.put("name", name);
        boolean useMaterialDefaults = (Boolean)helper.getProperties().getOrDefault("org.citygml4j.cityjson.useMaterialDefaults", Boolean.class, () -> true);
        if (useMaterialDefaults || object.isSetAmbientIntensity()) {
            node.put("ambientIntensity", object.getAmbientIntensity());
        }
        if (useMaterialDefaults || object.isSetDiffuseColor()) {
            ArrayNode diffuseColor = node.putArray("diffuseColor");
            object.getDiffuseColor().toList().forEach(arg_0 -> ((ArrayNode)diffuseColor).add(arg_0));
        }
        if (useMaterialDefaults || object.isSetEmissiveColor()) {
            ArrayNode emissiveColor = node.putArray("emissiveColor");
            object.getEmissiveColor().toList().forEach(arg_0 -> ((ArrayNode)emissiveColor).add(arg_0));
        }
        if (useMaterialDefaults || object.isSetSpecularColor()) {
            ArrayNode specularColor = node.putArray("specularColor");
            object.getSpecularColor().toList().forEach(arg_0 -> ((ArrayNode)specularColor).add(arg_0));
        }
        if (useMaterialDefaults || object.isSetShininess()) {
            node.put("shininess", object.getShininess());
        }
        if (useMaterialDefaults || object.isSetTransparency()) {
            node.put("transparency", object.getTransparency());
        }
        if (useMaterialDefaults || object.isSetIsSmooth()) {
            node.put("isSmooth", object.getIsSmooth());
        }
    }

    private Color toColor(ArrayNode node, double defaultValue) {
        return new Color(node.get(0).asDouble(defaultValue), node.get(1).asDouble(defaultValue), node.get(2).asDouble(defaultValue));
    }
}

