/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.appearance.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.appearance.ParameterizedTexture;
import org.citygml4j.core.model.appearance.X3DMaterial;

public class AppearanceInfo {
    private final Map<String, Appearance> appearances = new HashMap<String, Appearance>();
    private Map<Integer, X3DMaterial> materials;
    private Map<Integer, ParameterizedTexture> textures;

    public List<Appearance> getAppearances() {
        return new ArrayList<Appearance>(this.appearances.values());
    }

    public boolean hasAppearances() {
        return !this.appearances.isEmpty();
    }

    Appearance getAppearance(String theme) {
        return this.appearances.get(theme);
    }

    void addAppearance(String theme, Appearance appearance) {
        this.appearances.put(theme, appearance);
    }

    X3DMaterial getMaterial(int index) {
        return this.materials != null ? this.materials.get(index) : null;
    }

    void addMaterial(int index, X3DMaterial material) {
        if (this.materials == null) {
            this.materials = new HashMap<Integer, X3DMaterial>();
        }
        this.materials.put(index, material);
    }

    ParameterizedTexture getTexture(int index) {
        return this.textures != null ? this.textures.get(index) : null;
    }

    void addTexture(int index, ParameterizedTexture texture) {
        if (this.textures == null) {
            this.textures = new HashMap<Integer, ParameterizedTexture>();
        }
        this.textures.put(index, texture);
    }
}

