/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.bridge;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.construction.AbstractConstructionAdapter;
import org.citygml4j.cityjson.adapter.core.AddressAdapter;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.bridge.AbstractBridge;
import org.citygml4j.core.model.bridge.BridgeConstructiveElement;
import org.citygml4j.core.model.bridge.BridgeConstructiveElementProperty;
import org.citygml4j.core.model.bridge.BridgeFurniture;
import org.citygml4j.core.model.bridge.BridgeFurnitureProperty;
import org.citygml4j.core.model.bridge.BridgeInstallation;
import org.citygml4j.core.model.bridge.BridgeInstallationProperty;
import org.citygml4j.core.model.bridge.BridgeRoom;
import org.citygml4j.core.model.bridge.BridgeRoomProperty;
import org.citygml4j.core.model.construction.RelationToConstruction;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.Address;
import org.citygml4j.core.model.core.AddressProperty;
import org.citygml4j.core.model.core.StandardObjectClassifier;
import org.citygml4j.core.model.deprecated.bridge.DeprecatedPropertiesOfAbstractBridge;

public abstract class AbstractBridgeAdapter<T extends AbstractBridge>
extends AbstractConstructionAdapter<T> {
    private final Map<CityJSONVersion, EnumSet<GeometryType>> allowedTypes = new EnumMap<CityJSONVersion, EnumSet<GeometryType>>(CityJSONVersion.class);

    public AbstractBridgeAdapter() {
        this.allowedTypes.put(CityJSONVersion.v1_1, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.COMPOSITE_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID));
        this.allowedTypes.put(CityJSONVersion.v1_0, EnumSet.of(GeometryType.MULTI_SURFACE, GeometryType.SOLID, GeometryType.COMPOSITE_SOLID));
    }

    @Override
    public void buildObject(T object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        super.buildObject(object, attributes, node, parent, helper);
        helper.buildStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        JsonNode isMovable = attributes.consume("isMovable");
        if (isMovable.isBoolean()) {
            object.setIsMovable(Boolean.valueOf(isMovable.asBoolean()));
        }
        Iterator children = node.path("children").elements();
        block13: while (children.hasNext()) {
            String child = ((JsonNode)children.next()).asText();
            switch (helper.getCityObjectType(child)) {
                case "BridgeInstallation": {
                    object.getBridgeInstallations().add(new BridgeInstallationProperty(helper.getCityObject(child, BridgeInstallation.class)));
                    break;
                }
                case "BridgeConstructiveElement": 
                case "BridgeConstructionElement": {
                    object.getBridgeConstructiveElements().add(new BridgeConstructiveElementProperty(helper.getCityObject(child, BridgeConstructiveElement.class)));
                    break;
                }
                case "BridgeRoom": {
                    object.getBridgeRooms().add(new BridgeRoomProperty(helper.getCityObject(child, BridgeRoom.class)));
                    break;
                }
                case "BridgeFurniture": {
                    object.getBridgeFurniture().add(new BridgeFurnitureProperty(helper.getCityObject(child, BridgeFurniture.class)));
                    break;
                }
                default: {
                    continue block13;
                }
            }
            children.remove();
        }
    }

    @Override
    public void writeObject(T object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        super.writeObject(object, node, helper);
        CityJSONVersion version = helper.getVersion();
        ObjectNode attributes = helper.getOrPutObject("attributes", node);
        helper.writeStandardObjectClassifier((StandardObjectClassifier)object, attributes);
        if (object.isSetIsMovable()) {
            attributes.put("isMovable", object.getIsMovable());
        }
        if (object.isSetAddresses()) {
            ArrayNode addresses = helper.createArray();
            for (AddressProperty property : object.getAddresses()) {
                ObjectNode address;
                if (!property.isSetObject() || (address = helper.getObjectUsingSerializer((Address)property.getObject(), AddressAdapter.class)).isEmpty()) continue;
                addresses.add((JsonNode)address);
                if (version != CityJSONVersion.v1_0) continue;
                break;
            }
            if (!addresses.isEmpty()) {
                node.set("address", (JsonNode)(version == CityJSONVersion.v1_0 ? addresses.get(0) : addresses));
            }
        }
        if (object.isSetBridgeInstallations()) {
            for (BridgeInstallationProperty property : object.getBridgeInstallations()) {
                if (!property.isSetInlineObject() || version == CityJSONVersion.v1_0 && ((BridgeInstallation)property.getObject()).getRelationToConstruction() != RelationToConstruction.OUTSIDE) continue;
                helper.writeChildObject((BridgeInstallation)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (object.isSetBridgeConstructiveElements()) {
            for (BridgeInstallationProperty property : object.getBridgeConstructiveElements()) {
                if (!property.isSetInlineObject()) continue;
                helper.writeChildObject((BridgeConstructiveElement)property.getObject(), (AbstractFeature)object, node);
            }
        }
        if (version == CityJSONVersion.v1_1) {
            if (object.isSetBridgeRooms()) {
                for (BridgeInstallationProperty property : object.getBridgeRooms()) {
                    if (!property.isSetInlineObject()) continue;
                    helper.writeChildObject((BridgeRoom)property.getObject(), (AbstractFeature)object, node);
                }
            }
            if (object.isSetBridgeFurniture()) {
                for (BridgeInstallationProperty property : object.getBridgeFurniture()) {
                    if (!property.isSetInlineObject()) continue;
                    helper.writeChildObject((BridgeFurniture)property.getObject(), (AbstractFeature)object, node);
                }
            }
        }
    }

    @Override
    public EnumSet<GeometryType> getAllowedGeometryTypes(CityJSONVersion version) {
        return this.allowedTypes.get((Object)version);
    }

    @Override
    public Map<Integer, MultiSurfaceProvider> getMultiSurfaceProviders(T object) {
        if (object.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfAbstractBridge properties = object.getDeprecatedProperties();
            return Map.of(1, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfAbstractBridge)properties).getLod1MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfAbstractBridge)properties).setLod1MultiSurface(arg_0)), 4, MultiSurfaceProvider.of(() -> ((DeprecatedPropertiesOfAbstractBridge)properties).getLod4MultiSurface(), arg_0 -> ((DeprecatedPropertiesOfAbstractBridge)properties).setLod4MultiSurface(arg_0)));
        }
        return null;
    }
}

