/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.generics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Map;
import org.citygml4j.cityjson.adapter.generics.AbstractGenericAttributeAdapter;
import org.citygml4j.cityjson.annotation.CityJSONElement;
import org.citygml4j.cityjson.annotation.CityJSONElements;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.generics.GenericAttributeType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.core.AbstractGenericAttribute;
import org.citygml4j.core.model.core.AbstractGenericAttributeProperty;
import org.citygml4j.core.model.generics.GenericAttributeSet;

@CityJSONElements(value={@CityJSONElement(name="GenericAttributeSet", schema="CityJSON-Core", version=CityJSONVersion.v1_1), @CityJSONElement(name="GenericAttributeSet", schema="CityJSON-Core", version=CityJSONVersion.v1_0)})
public class GenericAttributeSetAdapter
extends AbstractGenericAttributeAdapter<GenericAttributeSet> {
    @Override
    public GenericAttributeSet createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new GenericAttributeSet();
    }

    @Override
    public void buildObject(GenericAttributeSet object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        block3: {
            block2: {
                if (!node.isArray()) break block2;
                for (JsonNode value : node) {
                    AbstractGenericAttribute<?> attribute = helper.getGenericAttribute("value", value);
                    object.getValue().add(new AbstractGenericAttributeProperty(attribute));
                }
                break block3;
            }
            if (!node.isObject()) break block3;
            Iterator iterator = node.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                AbstractGenericAttribute<?> attribute = helper.getGenericAttribute((String)entry.getKey(), (JsonNode)entry.getValue());
                object.getValue().add(new AbstractGenericAttributeProperty(attribute));
            }
        }
    }

    @Override
    public void writeObject(GenericAttributeSet object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        if (object.getName() != null && object.isSetValue()) {
            String name = null;
            boolean asArray = true;
            for (AbstractGenericAttributeProperty property : object.getValue()) {
                if (property.getObject() == null) continue;
                AbstractGenericAttribute genericAttribute = (AbstractGenericAttribute)property.getObject();
                if (name == null) {
                    name = genericAttribute.getName();
                    continue;
                }
                if (name.equalsIgnoreCase(genericAttribute.getName())) continue;
                asArray = false;
                break;
            }
            ArrayNode genericAttributeSet = asArray ? node.putArray(object.getName()) : node.putObject(object.getName());
            for (AbstractGenericAttributeProperty property : object.getValue()) {
                ObjectNode genericAttribute;
                if (property.getObject() == null || (genericAttribute = helper.getObject((AbstractGenericAttribute)property.getObject())) == null || genericAttribute.isEmpty()) continue;
                if (asArray) {
                    JsonNode value = genericAttribute.get((String)genericAttribute.fieldNames().next());
                    genericAttributeSet.add(value);
                    continue;
                }
                ((ObjectNode)genericAttributeSet).setAll(genericAttribute);
            }
            this.registerType(object.getName(), GenericAttributeType.GENERIC_ATTRIBUTE_SET, helper);
        }
    }
}

