/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.citygml4j.cityjson.adapter.appearance.builder.AppearanceBuilder;
import org.citygml4j.cityjson.adapter.geometry.MultiSurfaceProvider;
import org.citygml4j.cityjson.adapter.geometry.builder.CurveGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObjectBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.MaterialBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.PointGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.SemanticsBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.SolidGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.SpaceGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.SurfaceGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.SurfaceProvider;
import org.citygml4j.cityjson.adapter.geometry.builder.TemplateGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.TemplateInfo;
import org.citygml4j.cityjson.adapter.geometry.builder.TextureBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.util.BoundaryFilter;
import org.citygml4j.cityjson.util.lod.DefaultLodMapper;
import org.citygml4j.cityjson.util.lod.LodMapper;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.AbstractSpace;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;

public class GeometryBuilder {
    private final CityJSONBuilderHelper helper;
    private final VerticesBuilder verticesBuilder;
    private final VerticesBuilder templatesVerticesBuilder;
    private final SpaceGeometryBuilder spaceGeometryBuilder;
    private final SemanticsBuilder semanticsBuilder;
    private final MaterialBuilder materialBuilder;
    private final TextureBuilder textureBuilder;
    private final TemplateInfo templateInfo;
    private final Map<AbstractSpace, Map<Integer, MultiSurfaceProvider>> providers = new IdentityHashMap<AbstractSpace, Map<Integer, MultiSurfaceProvider>>();
    private LodMapper lodMapper = new DefaultLodMapper();
    private boolean transformTemplateGeometries;
    private boolean assignAppearancesToImplicitGeometries;

    public GeometryBuilder(ArrayNode vertices, ObjectNode templates, AppearanceBuilder appearanceBuilder, CityJSONBuilderHelper helper) {
        this.helper = helper;
        this.verticesBuilder = new VerticesBuilder(vertices);
        this.templatesVerticesBuilder = new VerticesBuilder(helper.getOrPutArray("vertices-templates", templates));
        this.spaceGeometryBuilder = new SpaceGeometryBuilder(this, helper);
        this.semanticsBuilder = new SemanticsBuilder(helper);
        this.materialBuilder = new MaterialBuilder(appearanceBuilder, helper);
        this.textureBuilder = new TextureBuilder(appearanceBuilder, helper);
        this.templateInfo = new TemplateInfo(helper.getOrPutArray("templates", templates));
    }

    public VerticesBuilder getVerticesBuilder() {
        return this.verticesBuilder;
    }

    public VerticesBuilder getTemplatesVerticesBuilder() {
        return this.templatesVerticesBuilder;
    }

    public boolean isTransformTemplateGeometries() {
        return this.transformTemplateGeometries;
    }

    public void setTransformTemplateGeometries(boolean transformTemplateGeometries) {
        this.transformTemplateGeometries = transformTemplateGeometries;
    }

    public boolean isAssignAppearancesToImplicitGeometries() {
        return this.assignAppearancesToImplicitGeometries;
    }

    public void setAssignAppearancesToImplicitGeometries(boolean assignAppearancesToImplicitGeometries) {
        this.assignAppearancesToImplicitGeometries = assignAppearancesToImplicitGeometries;
    }

    public LodMapper getLodMapper() {
        return this.lodMapper;
    }

    public void setLodMapper(LodMapper lodMapper) {
        this.lodMapper = Objects.requireNonNull(lodMapper, "The LoD mapper must not be null.");
    }

    public List<Appearance> getGlobalAppearances() {
        return this.templateInfo.getAppearances();
    }

    public boolean hasGlobalAppearances() {
        return this.templateInfo.hasAppearances();
    }

    public void setMultiSurfaceProviders(AbstractSpace space, Map<Integer, MultiSurfaceProvider> providers) {
        if (providers != null) {
            this.providers.put(space, providers);
        }
    }

    public GeometryObject getGeometry(AbstractFeature object, JsonNode geometry, int lod, BoundaryFilter filter) {
        GeometryObject geometryObject = GeometryObject.newInstance();
        this.getGeometry(object, geometryObject, geometry, lod, filter, this.verticesBuilder);
        return geometryObject.isSetGeometry() || geometryObject.isSetImplicitGeometry() ? geometryObject : null;
    }

    void getGeometry(AbstractFeature object, GeometryObject geometryObject, JsonNode geometry, int lod, BoundaryFilter filter, VerticesBuilder verticesBuilder) {
        if (geometry != null && geometry.isObject()) {
            GeometryType type = GeometryType.fromValue(geometry.path("type").asText());
            GeometryObjectBuilder builder = null;
            if (GeometryType.SURFACE_TYPES.contains((Object)type)) {
                builder = new SurfaceGeometryBuilder(object, filter, verticesBuilder);
            } else if (GeometryType.SOLID_TYPES.contains((Object)type)) {
                builder = new SolidGeometryBuilder(object, filter, verticesBuilder);
            } else if (type == GeometryType.MULTI_LINE_STRING) {
                builder = new CurveGeometryBuilder(object, filter, verticesBuilder);
            } else if (type == GeometryType.MULTI_POINT) {
                builder = new PointGeometryBuilder(object, filter, verticesBuilder);
            } else if (type == GeometryType.TEMPLATE_GEOMETRY) {
                builder = new TemplateGeometryBuilder(object, filter, this.templateInfo, this, this.helper);
            }
            if (builder != null) {
                ((GeometryObjectBuilder)builder).build(geometry, type, lod, geometryObject);
                if (geometryObject.getGeometry() != null && builder instanceof SurfaceProvider) {
                    List<SurfaceProperty> surfaces = ((SurfaceProvider)((Object)builder)).getSurfaces();
                    this.materialBuilder.build(geometry.path("material"), surfaces, geometryObject);
                    this.textureBuilder.build(geometry.path("texture"), surfaces, geometryObject);
                    if (object instanceof AbstractSpace) {
                        AbstractSpace space = (AbstractSpace)object;
                        JsonNode semantics = geometry.path("semantics");
                        this.semanticsBuilder.build(space, semantics, filter, surfaces, lod, geometryObject);
                    }
                }
            }
        }
    }

    public Map<Integer, List<GeometryObject>> getGeometries(AbstractFeature object, JsonNode geometries, BoundaryFilter filter) {
        HashMap<Integer, List<GeometryObject>> geometryObjects = new HashMap<Integer, List<GeometryObject>>();
        Map<Double, List<JsonNode>> geometriesByLod = this.groupGeometriesByLod(geometries);
        if (!geometriesByLod.isEmpty()) {
            this.lodMapper.buildMapping(geometriesByLod.keySet());
            int maxLod = Collections.max(geometriesByLod.keySet()).intValue() + 1;
            for (int lod = 0; lod < maxLod; ++lod) {
                List nodes = geometriesByLod.getOrDefault(this.lodMapper.getMappingFor(lod), Collections.emptyList());
                for (JsonNode geometry : nodes) {
                    GeometryObject geometryObject = this.getGeometry(object, geometry, lod, filter);
                    if (geometryObject == null) continue;
                    geometryObjects.computeIfAbsent(lod, v -> new ArrayList()).add(geometryObject);
                }
            }
        }
        return geometryObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGeometries(AbstractSpace space, JsonNode geometries, BoundaryFilter filter) {
        try {
            if (geometries != null && geometries.isArray()) {
                this.spaceGeometryBuilder.build(space, geometries, filter, this.providers.getOrDefault(space, Collections.emptyMap()));
            }
        }
        finally {
            this.providers.remove(space);
        }
    }

    public Map<Double, List<JsonNode>> groupGeometriesByLod(JsonNode geometries) {
        if (!geometries.isEmpty()) {
            HashMap<Double, List<JsonNode>> geometriesByLod = new HashMap<Double, List<JsonNode>>();
            for (JsonNode geometry : geometries) {
                GeometryType type = GeometryType.fromValue(geometry.path("type").asText());
                JsonNode lod = type != GeometryType.TEMPLATE_GEOMETRY ? geometry.path("lod") : this.templateInfo.getTemplate(geometry.path("template").asInt(-1)).path("lod");
                if (!lod.isValueNode()) continue;
                geometriesByLod.computeIfAbsent(lod.asDouble(), v -> new ArrayList()).add(geometry);
            }
            return geometriesByLod;
        }
        return Collections.emptyMap();
    }
}

