/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import java.util.Collections;
import java.util.List;
import org.citygml4j.cityjson.adapter.appearance.builder.AppearanceInfo;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.core.AbstractSpaceBoundary;
import org.citygml4j.core.model.core.ImplicitGeometry;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;

public class GeometryObject {
    private AbstractGeometry geometry;
    private ImplicitGeometry implicitGeometry;
    private List<AbstractSpaceBoundary> boundaries;
    private AppearanceInfo appearanceInfo;

    private GeometryObject() {
    }

    static GeometryObject newInstance() {
        return new GeometryObject();
    }

    public AbstractGeometry getGeometry() {
        return this.geometry;
    }

    public <T extends AbstractGeometry> T getGeometry(Class<T> type) {
        return (T)(type.isInstance(this.geometry) ? (AbstractGeometry)type.cast(this.geometry) : null);
    }

    public boolean isSetGeometry() {
        return this.geometry != null;
    }

    void setGeometry(AbstractGeometry geometry) {
        this.geometry = geometry;
        this.implicitGeometry = null;
    }

    public ImplicitGeometry getImplicitGeometry() {
        return this.implicitGeometry;
    }

    public boolean isSetImplicitGeometry() {
        return this.implicitGeometry != null;
    }

    void setImplicitGeometry(ImplicitGeometry implicitGeometry) {
        this.implicitGeometry = implicitGeometry;
        this.geometry = null;
    }

    public List<AbstractSpaceBoundary> getBoundaries() {
        return this.hasBoundaries() ? this.boundaries : Collections.emptyList();
    }

    public boolean hasBoundaries() {
        return this.boundaries != null && !this.boundaries.isEmpty();
    }

    void setBoundaries(List<AbstractSpaceBoundary> boundaries) {
        this.boundaries = boundaries;
    }

    public List<Appearance> getAppearances() {
        return this.hasAppearances() ? this.appearanceInfo.getAppearances() : Collections.emptyList();
    }

    public boolean hasAppearances() {
        return this.appearanceInfo != null && this.appearanceInfo.hasAppearances();
    }

    AppearanceInfo getAppearanceInfo() {
        if (this.appearanceInfo == null) {
            this.appearanceInfo = new AppearanceInfo();
        }
        return this.appearanceInfo;
    }

    void setAppearanceInfo(AppearanceInfo appearanceInfo) {
        this.appearanceInfo = appearanceInfo;
    }

    void reset(boolean keepAppearances) {
        this.geometry = null;
        this.implicitGeometry = null;
        this.boundaries = null;
        if (!keepAppearances) {
            this.appearanceInfo = null;
        }
    }
}

