/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.adapter.appearance.builder.AppearanceBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.core.model.appearance.GeometryReference;
import org.citygml4j.core.model.appearance.X3DMaterial;
import org.xmlobjects.gml.model.base.AbstractGML;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurface;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSurface;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSurface;
import org.xmlobjects.gml.model.geometry.primitives.Shell;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;
import org.xmlobjects.gml.visitor.GeometryVisitor;
import org.xmlobjects.gml.visitor.GeometryWalker;

public class MaterialBuilder {
    private final AppearanceBuilder appearanceBuilder;
    private final CityJSONBuilderHelper helper;

    MaterialBuilder(AppearanceBuilder appearanceBuilder, CityJSONBuilderHelper helper) {
        this.appearanceBuilder = appearanceBuilder;
        this.helper = helper;
    }

    void build(JsonNode materials, List<SurfaceProperty> geometries, final GeometryObject geometryObject) {
        Iterator iterator = materials.fields();
        while (iterator.hasNext()) {
            final Map.Entry entry = (Map.Entry)iterator.next();
            final int value = ((JsonNode)entry.getValue()).path("value").asInt(-1);
            if (value == -1) {
                List<Integer> flatValues = this.flatValues((JsonNode)entry.getValue(), geometries.size());
                for (int index = 0; index < flatValues.size() && index < geometries.size(); ++index) {
                    int materialIndex = flatValues.get(index);
                    if (materialIndex == -1) continue;
                    AbstractSurface surface = (AbstractSurface)geometries.get(index).getObject();
                    this.addMaterial(materialIndex, (String)entry.getKey(), this.helper.getOrCreateId((AbstractGML)surface), geometryObject);
                }
                continue;
            }
            geometryObject.getGeometry().accept((GeometryVisitor)new GeometryWalker(){

                public void visit(MultiSurface multiSurface) {
                    MaterialBuilder.this.addMaterial(value, (String)entry.getKey(), MaterialBuilder.this.helper.getOrCreateId((AbstractGML)multiSurface), geometryObject);
                }

                public void visit(CompositeSurface compositeSurface) {
                    MaterialBuilder.this.addMaterial(value, (String)entry.getKey(), MaterialBuilder.this.helper.getOrCreateId((AbstractGML)compositeSurface), geometryObject);
                }

                public void visit(Shell shell) {
                    MaterialBuilder.this.addMaterial(value, (String)entry.getKey(), MaterialBuilder.this.helper.getOrCreateId((AbstractGML)shell), geometryObject);
                }
            });
        }
    }

    private void addMaterial(int index, String theme, String target, GeometryObject geometryObject) {
        X3DMaterial material = this.appearanceBuilder.getOrCreateMaterial(index, theme, geometryObject.getAppearanceInfo());
        if (material != null) {
            material.getTargets().add(new GeometryReference("#" + target));
        }
    }

    private List<Integer> flatValues(JsonNode material, int size) {
        ArrayList<Integer> flatValues = new ArrayList<Integer>();
        this.flatValues(material.path("values"), flatValues);
        return flatValues;
    }

    private void flatValues(JsonNode values, List<Integer> flatValues) {
        for (JsonNode value : values) {
            if (value.isArray()) {
                this.flatValues(value, flatValues);
                continue;
            }
            flatValues.add(value.asInt(-1));
        }
    }
}

