/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObjectBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.SurfaceProvider;
import org.citygml4j.cityjson.adapter.geometry.builder.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.util.BoundaryFilter;
import org.citygml4j.core.model.core.AbstractFeature;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.DirectPositionList;
import org.xmlobjects.gml.model.geometry.aggregates.MultiSurface;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSurface;
import org.xmlobjects.gml.model.geometry.primitives.AbstractRing;
import org.xmlobjects.gml.model.geometry.primitives.AbstractRingProperty;
import org.xmlobjects.gml.model.geometry.primitives.AbstractSurface;
import org.xmlobjects.gml.model.geometry.primitives.LinearRing;
import org.xmlobjects.gml.model.geometry.primitives.Polygon;
import org.xmlobjects.gml.model.geometry.primitives.SurfaceProperty;

public class SurfaceGeometryBuilder
extends GeometryObjectBuilder
implements SurfaceProvider {
    private final VerticesBuilder verticesBuilder;
    private List<SurfaceProperty> surfaces;

    SurfaceGeometryBuilder(AbstractFeature object, BoundaryFilter filter, VerticesBuilder verticesBuilder) {
        super(object, filter);
        this.verticesBuilder = verticesBuilder;
    }

    @Override
    void build(JsonNode node, GeometryType type, int lod, GeometryObject geometryObject) {
        JsonNode boundaries = node.path("boundaries");
        if (boundaries.isArray()) {
            this.surfaces = this.buildSurfaces((ArrayNode)boundaries);
            if (this.surfaces != null) {
                if (type == GeometryType.COMPOSITE_SURFACE) {
                    geometryObject.setGeometry((AbstractGeometry)new CompositeSurface(this.surfaces));
                } else {
                    geometryObject.setGeometry((AbstractGeometry)new MultiSurface(this.surfaces));
                }
            }
        }
    }

    @Override
    public List<SurfaceProperty> getSurfaces() {
        return this.surfaces != null ? this.surfaces : Collections.emptyList();
    }

    List<SurfaceProperty> buildSurfaces(ArrayNode surfaces) {
        if (!surfaces.isEmpty()) {
            ArrayList<SurfaceProperty> geometries = new ArrayList<SurfaceProperty>(surfaces.size());
            for (JsonNode surface : surfaces) {
                Polygon polygon;
                Polygon polygon2 = polygon = surface.isArray() ? this.createPolygon((ArrayNode)surface) : null;
                if (polygon != null) {
                    geometries.add(new SurfaceProperty((AbstractSurface)polygon));
                    continue;
                }
                return null;
            }
            return geometries;
        }
        return null;
    }

    private Polygon createPolygon(ArrayNode rings) {
        LinearRing boundary;
        JsonNode ring = rings.path(0);
        if (ring.isArray() && (boundary = this.createLinearRing((ArrayNode)ring)) != null) {
            Polygon polygon = new Polygon((AbstractRing)boundary);
            for (int i = 1; i < rings.size(); ++i) {
                ring = rings.get(i);
                LinearRing linearRing = boundary = ring.isArray() ? this.createLinearRing((ArrayNode)ring) : null;
                if (boundary == null) {
                    return null;
                }
                polygon.getInterior().add(new AbstractRingProperty((AbstractRing)boundary));
            }
            return polygon;
        }
        return null;
    }

    private LinearRing createLinearRing(ArrayNode ring) {
        List<Double> vertices = this.verticesBuilder.getVertices(ring, true);
        if (!vertices.isEmpty()) {
            DirectPositionList posList = new DirectPositionList(vertices);
            posList.setSrsDimension(Integer.valueOf(3));
            return new LinearRing(posList);
        }
        return null;
    }
}

