/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.builder;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.List;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObject;
import org.citygml4j.cityjson.adapter.geometry.builder.GeometryObjectBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.PointGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.builder.TemplateInfo;
import org.citygml4j.cityjson.adapter.geometry.builder.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.util.BoundaryFilter;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.core.AbstractAppearance;
import org.citygml4j.core.model.core.AbstractAppearanceProperty;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.ImplicitGeometry;
import org.citygml4j.core.model.core.TransformationMatrix4x4;
import org.xmlobjects.gml.model.base.AbstractGML;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.GeometryProperty;
import org.xmlobjects.gml.model.geometry.aggregates.MultiPoint;
import org.xmlobjects.gml.model.geometry.primitives.Point;
import org.xmlobjects.gml.model.geometry.primitives.PointProperty;
import org.xmlobjects.gml.util.Matrices;
import org.xmlobjects.gml.util.jama.Matrix;

public class TemplateGeometryBuilder
extends GeometryObjectBuilder {
    private final TemplateInfo templateInfo;
    private final GeometryBuilder geometryBuilder;
    private final CityJSONBuilderHelper helper;
    private final VerticesBuilder templatesVerticesBuilder;
    private final PointGeometryBuilder pointGeometryBuilder;

    TemplateGeometryBuilder(AbstractFeature object, BoundaryFilter filter, TemplateInfo templateInfo, GeometryBuilder geometryBuilder, CityJSONBuilderHelper helper) {
        super(object, filter);
        this.templateInfo = templateInfo;
        this.geometryBuilder = geometryBuilder;
        this.helper = helper;
        this.templatesVerticesBuilder = geometryBuilder.getTemplatesVerticesBuilder();
        this.pointGeometryBuilder = new PointGeometryBuilder(object, filter, geometryBuilder.getVerticesBuilder());
    }

    @Override
    void build(JsonNode node, GeometryType type, int lod, GeometryObject geometryObject) {
        int template = node.path("template").asInt(-1);
        PointProperty referencePoint = this.getReferencePoint(node, lod, geometryObject);
        TransformationMatrix4x4 matrix = this.getTransformationMatrix(node.path("transformationMatrix"));
        if (template == -1 || referencePoint == null || matrix == null) {
            return;
        }
        if (!this.geometryBuilder.isTransformTemplateGeometries()) {
            ImplicitGeometry implicitGeometry = this.createImplicitGeometry(template, lod);
            if (implicitGeometry != null) {
                implicitGeometry.setReferencePoint(referencePoint);
                implicitGeometry.setTransformationMatrix(matrix);
                geometryObject.setImplicitGeometry(implicitGeometry);
            }
        } else {
            this.transformTemplateGeometry(template, referencePoint, matrix, lod, geometryObject);
        }
    }

    private ImplicitGeometry createImplicitGeometry(int index, int lod) {
        String reference = this.templateInfo.getReference(index);
        if (reference != null) {
            return new ImplicitGeometry(new GeometryProperty(reference));
        }
        GeometryObject geometryObject = GeometryObject.newInstance();
        if (!this.geometryBuilder.isAssignAppearancesToImplicitGeometries()) {
            geometryObject.setAppearanceInfo(this.templateInfo.getAppearanceInfo());
        }
        this.geometryBuilder.getGeometry(this.object, geometryObject, this.templateInfo.getTemplate(index), lod, this.filter, this.templatesVerticesBuilder);
        if (geometryObject.isSetGeometry()) {
            AbstractGeometry geometry = geometryObject.getGeometry();
            this.templateInfo.addReference(index, "#" + this.helper.getOrCreateId((AbstractGML)geometry));
            ImplicitGeometry implicitGeometry = new ImplicitGeometry(new GeometryProperty(geometry));
            if (geometryObject.hasAppearances() && this.geometryBuilder.isAssignAppearancesToImplicitGeometries()) {
                for (Appearance appearance : geometryObject.getAppearances()) {
                    implicitGeometry.getAppearances().add(new AbstractAppearanceProperty((AbstractAppearance)appearance));
                }
            }
            return implicitGeometry;
        }
        return null;
    }

    private void transformTemplateGeometry(int index, PointProperty referencePoint, TransformationMatrix4x4 matrix, int lod, GeometryObject geometryObject) {
        List point = ((Point)referencePoint.getObject()).toCoordinateList3D();
        final Matrix transform = matrix.getValue();
        transform.set(0, 3, transform.get(0, 3) + (Double)point.get(0));
        transform.set(1, 3, transform.get(1, 3) + (Double)point.get(1));
        transform.set(2, 3, transform.get(2, 3) + (Double)point.get(2));
        VerticesBuilder verticesBuilder = new VerticesBuilder(this.helper.createArray()){

            @Override
            public List<Double> getVertices(ArrayNode indexes, boolean appendLastVertex) {
                return Matrices.transform3D(TemplateGeometryBuilder.this.templatesVerticesBuilder.getVertices(indexes, appendLastVertex), (Matrix)transform);
            }
        };
        this.geometryBuilder.getGeometry(this.object, geometryObject, this.templateInfo.getTemplate(index), lod, this.filter, verticesBuilder);
    }

    private PointProperty getReferencePoint(JsonNode geometry, int lod, GeometryObject geometryObject) {
        this.pointGeometryBuilder.build(geometry, GeometryType.MULTI_POINT, lod, geometryObject);
        MultiPoint multiPoint = geometryObject.getGeometry(MultiPoint.class);
        return multiPoint != null ? (PointProperty)multiPoint.getPointMember().get(0) : null;
    }

    private TransformationMatrix4x4 getTransformationMatrix(JsonNode matrix) {
        if (matrix.isArray() && matrix.size() > 15) {
            ArrayList<Double> values = new ArrayList<Double>(16);
            for (int i = 0; i < matrix.size(); ++i) {
                values.add(matrix.path(i).asDouble(0.0));
            }
            return TransformationMatrix4x4.ofRowMajorList(values);
        }
        return null;
    }
}

