/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.adapter.geometry.serializer.MultiGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.TemplateInfo;
import org.citygml4j.cityjson.adapter.geometry.serializer.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.core.model.core.ImplicitGeometry;
import org.xmlobjects.gml.model.base.AbstractGML;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.DirectPosition;
import org.xmlobjects.gml.model.geometry.primitives.Point;
import org.xmlobjects.gml.util.jama.Matrix;
import org.xmlobjects.gml.visitor.GeometryVisitor;

public class GeometrySerializer {
    public static final int DEFAULT_VERTEX_PRECISION = 3;
    public static final int DEFAULT_TEMPLATE_PRECISION = 3;
    private final AppearanceSerializer appearanceSerializer;
    private final CityJSONSerializerHelper helper;
    private final Map<String, TemplateInfo> templates = new HashMap<String, TemplateInfo>();
    private final VerticesBuilder verticesBuilder = new VerticesBuilder(3);
    private final VerticesBuilder templatesVerticesBuilder = new VerticesBuilder(3);
    private boolean transformTemplateGeometries;

    public GeometrySerializer(AppearanceSerializer appearanceSerializer, CityJSONSerializerHelper helper) {
        this.appearanceSerializer = appearanceSerializer;
        this.helper = helper;
    }

    public VerticesBuilder getVerticesBuilder() {
        return this.verticesBuilder;
    }

    public VerticesBuilder getTemplatesVerticesBuilder() {
        return this.templatesVerticesBuilder;
    }

    public boolean isTransformTemplateGeometries() {
        return this.transformTemplateGeometries;
    }

    public void setTransformTemplateGeometries(boolean transformTemplateGeometries) {
        this.transformTemplateGeometries = transformTemplateGeometries;
    }

    public void addGeometry(AbstractGeometry geometry, Number lod, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        this.buildGeometry(geometry, lod, this.helper.getOrPutArray("geometry", object), allowedTypes, this.verticesBuilder);
    }

    public ObjectNode getGeometry(AbstractGeometry geometry, Number lod, EnumSet<GeometryType> allowedTypes) {
        return this.createGeometry(geometry, lod, this.verticesBuilder, allowedTypes);
    }

    public void addTemplateGeometry(ImplicitGeometry geometry, Number lod, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        if (geometry == null || geometry.getRelativeGeometry() == null || geometry.getRelativeGeometry().getObject() == null || geometry.getReferencePoint() == null || geometry.getReferencePoint().getObject() == null || geometry.getTransformationMatrix() == null) {
            return;
        }
        if (!this.transformTemplateGeometries) {
            this.buildTemplateGeometry(geometry, lod, object, allowedTypes);
        } else {
            this.convertTemplateGeometry(geometry, lod, object, allowedTypes);
        }
    }

    public boolean hasTemplates() {
        return !this.templates.isEmpty();
    }

    public Iterator<ObjectNode> getTemplates() {
        return this.templates.values().stream().sorted(Comparator.comparingInt(TemplateInfo::getIndex)).map(TemplateInfo::getNode).iterator();
    }

    private ObjectNode createGeometry(AbstractGeometry geometry, Number lod, VerticesBuilder verticesBuilder, EnumSet<GeometryType> allowedTypes) {
        ArrayNode node = this.helper.createArray();
        this.buildGeometry(geometry, lod, node, allowedTypes, verticesBuilder);
        return node.size() == 1 ? (ObjectNode)node.get(0) : null;
    }

    private void buildGeometry(AbstractGeometry geometry, Number lod, ArrayNode node, EnumSet<GeometryType> allowedTypes, VerticesBuilder verticesBuilder) {
        if (geometry != null && allowedTypes != null) {
            MultiGeometryBuilder builder = new MultiGeometryBuilder(allowedTypes, this.appearanceSerializer, verticesBuilder, this.helper);
            geometry.accept((GeometryVisitor)builder);
            builder.build(geometry, lod, node);
        }
    }

    private void buildTemplateGeometry(ImplicitGeometry geometry, Number lod, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        AbstractGeometry relativeGeometry = geometry.getRelativeGeometry().getObject();
        TemplateInfo templateInfo = this.templates.get(this.helper.getOrCreateId((AbstractGML)relativeGeometry));
        if (templateInfo == null) {
            ObjectNode template = this.createGeometry(relativeGeometry, lod, this.templatesVerticesBuilder, EnumSet.allOf(GeometryType.class));
            templateInfo = template != null ? new TemplateInfo(template, this.templates.size()) : TemplateInfo.NULL_TEMPLATE;
            this.templates.put(relativeGeometry.getId(), templateInfo);
        }
        if (templateInfo == TemplateInfo.NULL_TEMPLATE) {
            return;
        }
        GeometryType type = GeometryType.fromValue(templateInfo.getNode().path("type").asText());
        if (!allowedTypes.contains((Object)type)) {
            return;
        }
        double[] matrix = geometry.getTransformationMatrix().getValue().getRowPackedCopy();
        Point referencePoint = (Point)geometry.getReferencePoint().getObject();
        List coordinates = referencePoint.toCoordinateList3D();
        coordinates.set(0, (Double)coordinates.get(0) + matrix[3]);
        coordinates.set(1, (Double)coordinates.get(1) + matrix[7]);
        coordinates.set(2, (Double)coordinates.get(2) + matrix[11]);
        matrix[3] = 0.0;
        matrix[7] = 0.0;
        matrix[11] = 0.0;
        ObjectNode boundary = this.createGeometry((AbstractGeometry)new Point(new DirectPosition(coordinates)), lod, this.verticesBuilder, EnumSet.of(GeometryType.MULTI_POINT));
        if (boundary == null) {
            return;
        }
        ObjectNode node = this.helper.getOrPutArray("geometry", object).addObject();
        node.put("type", GeometryType.TEMPLATE_GEOMETRY.toTypeName());
        node.put("template", templateInfo.getIndex());
        node.set("boundaries", boundary.path("boundaries"));
        ArrayNode transformationMatrix = node.putArray("transformationMatrix");
        Arrays.stream(matrix).forEach(arg_0 -> ((ArrayNode)transformationMatrix).add(arg_0));
    }

    private void convertTemplateGeometry(ImplicitGeometry geometry, Number lod, ObjectNode object, EnumSet<GeometryType> allowedTypes) {
        final Matrix matrix = geometry.getTransformationMatrix().getValue();
        final List translate = ((Point)geometry.getReferencePoint().getObject()).toCoordinateList3D();
        VerticesBuilder builder = new VerticesBuilder(0){

            @Override
            public List<Integer> addVertices(List<Double> vertices) {
                int size = vertices.size();
                for (int i = 0; i < size && i + 3 <= size; i += 3) {
                    Matrix v = new Matrix(new double[]{vertices.get(i), vertices.get(i + 1), vertices.get(i + 2), 1.0}, 4);
                    v = matrix.times(v);
                    vertices.set(i, v.get(0, 0) + (Double)translate.get(0));
                    vertices.set(i + 1, v.get(1, 0) + (Double)translate.get(1));
                    vertices.set(i + 2, v.get(2, 0) + (Double)translate.get(2));
                }
                return GeometrySerializer.this.verticesBuilder.addVertices(vertices);
            }
        };
        AbstractGeometry relativeGeometry = geometry.getRelativeGeometry().getObject();
        this.buildGeometry(relativeGeometry, lod, this.helper.getOrPutArray("geometry", object), allowedTypes, builder);
    }

    public void reset() {
        this.verticesBuilder.reset();
        this.templatesVerticesBuilder.reset();
        this.templates.clear();
    }
}

