/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.geometry.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.adapter.geometry.serializer.GeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.SurfaceGeometryBuilder;
import org.citygml4j.cityjson.adapter.geometry.serializer.VerticesBuilder;
import org.citygml4j.cityjson.model.geometry.GeometryType;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.model.geometry.complexes.CompositeSolid;
import org.xmlobjects.gml.model.geometry.primitives.Shell;
import org.xmlobjects.gml.model.geometry.primitives.ShellProperty;
import org.xmlobjects.gml.model.geometry.primitives.Solid;
import org.xmlobjects.gml.visitor.GeometryVisitor;

public class SolidGeometryBuilder
extends GeometryBuilder {
    private final EnumSet<GeometryType> allowedTypes;
    private final SurfaceGeometryBuilder builder;
    private final List<Integer> shells = new ArrayList<Integer>();
    private final List<Integer> solids = new ArrayList<Integer>();
    private final boolean shouldBuild;
    private boolean isComposite;
    private int disconnectedSolids;

    SolidGeometryBuilder(EnumSet<GeometryType> allowedTypes, AppearanceSerializer appearanceSerializer, VerticesBuilder verticesBuilder, CityJSONSerializerHelper helper) {
        super(helper);
        this.allowedTypes = allowedTypes;
        this.builder = new SurfaceGeometryBuilder(allowedTypes, appearanceSerializer, verticesBuilder, helper);
        this.shouldBuild = GeometryType.SOLID_TYPES.stream().anyMatch(allowedTypes::contains);
    }

    ObjectNode build(AbstractGeometry geometry, Number lod) {
        ObjectNode node = this.builder.build(geometry, lod);
        if (node != null) {
            GeometryType type = this.size() == 1 && this.allowedTypes.contains((Object)GeometryType.SOLID) ? GeometryType.SOLID : (this.disconnectedSolids == 1 && this.allowedTypes.contains((Object)GeometryType.COMPOSITE_SOLID) ? GeometryType.COMPOSITE_SOLID : GeometryType.MULTI_SOLID);
            node.put("type", type.toTypeName());
            this.sliceSolid(node, this.shells);
            if (this.solids.size() > 1) {
                this.sliceSolid(node, this.solids);
            }
        }
        return node;
    }

    @Override
    int size() {
        return this.solids.size();
    }

    public void visit(Solid solid) {
        if (this.shouldBuild && (this.solids.size() == 0 || this.disconnectedSolids == 0 && this.allowedTypes.contains((Object)GeometryType.COMPOSITE_SOLID) || this.allowedTypes.contains((Object)GeometryType.MULTI_SOLID)) && solid.getExterior() != null && solid.getExterior().getObject() != null) {
            ((Shell)solid.getExterior().getObject()).accept((GeometryVisitor)this.builder);
            this.shells.add(this.builder.size());
            if (solid.isSetInterior()) {
                for (ShellProperty property : solid.getInterior()) {
                    if (property.getObject() == null) continue;
                    ((Shell)property.getObject()).accept((GeometryVisitor)this.builder);
                    this.shells.add(this.builder.size());
                }
            }
            this.solids.add(this.shells.size());
            if (!this.isComposite) {
                ++this.disconnectedSolids;
            }
        }
    }

    public void visit(CompositeSolid compositeSolid) {
        if (!this.isComposite) {
            this.isComposite = true;
            super.visit(compositeSolid);
            this.isComposite = false;
            ++this.disconnectedSolids;
        } else {
            super.visit(compositeSolid);
        }
    }

    private void sliceSolid(ObjectNode node, List<Integer> limits) {
        ObjectNode semantics;
        ArrayNode boundaries = (ArrayNode)node.get("boundaries");
        if (boundaries != null) {
            node.set("boundaries", (JsonNode)this.slice(boundaries, limits));
        }
        if ((semantics = (ObjectNode)node.get("semantics")) != null) {
            semantics.set("values", (JsonNode)this.slice(this.helper.getOrPutArray("values", semantics), limits));
        }
        this.sliceAppearance((ObjectNode)node.get("material"), limits);
        this.sliceAppearance((ObjectNode)node.get("texture"), limits);
    }

    private void sliceAppearance(ObjectNode appearance, List<Integer> limits) {
        if (appearance != null) {
            Iterator iterator = appearance.fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (!((JsonNode)entry.getValue()).isObject()) continue;
                ObjectNode material = (ObjectNode)entry.getValue();
                material.set("values", (JsonNode)this.slice(this.helper.getOrPutArray("values", material), limits));
            }
        }
    }

    private ArrayNode slice(ArrayNode array, List<Integer> limits) {
        ArrayNode result = this.helper.createArray();
        int index = 0;
        for (int limit : limits) {
            ArrayNode slice = result.addArray();
            while (index < limit) {
                slice.add(array.get(index));
                ++index;
            }
        }
        return result;
    }
}

