/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import org.citygml4j.cityjson.adapter.metadata.PointOfContactAdapter;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.metadata.Metadata;
import org.citygml4j.cityjson.model.metadata.PointOfContact;
import org.citygml4j.cityjson.model.metadata.ReferenceSystem;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;

public class MetadataAdapter
implements JsonObjectBuilder<Metadata>,
JsonObjectSerializer<Metadata> {
    @Override
    public Metadata createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new Metadata();
    }

    @Override
    public void buildObject(Metadata object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode referenceSystem;
        JsonNode geographicalExtent;
        JsonNode title;
        JsonNode referenceDate;
        JsonNode pointOfContact;
        CityJSONVersion version = helper.getVersion();
        JsonNode identifier = node.path(version == CityJSONVersion.v1_0 ? "fileIdentifier" : "identifier");
        if (identifier.isTextual()) {
            object.setIdentifier(identifier.asText());
        }
        if ((pointOfContact = node.path(version == CityJSONVersion.v1_0 ? "datasetPointOfContact" : "pointOfContact")).isObject()) {
            object.setPointOfContact((PointOfContact)helper.getObjectUsingBuilder(pointOfContact, PointOfContactAdapter.class));
        }
        if ((referenceDate = node.path(version == CityJSONVersion.v1_0 ? "datasetReferenceDate" : "referenceDate")).isTextual()) {
            try {
                object.setReferenceDate(LocalDate.parse(referenceDate.asText(), DateTimeFormatter.ISO_LOCAL_DATE));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((title = node.path(version == CityJSONVersion.v1_0 ? "datasetTitle" : "title")).isTextual()) {
            object.setTitle(title.asText());
        }
        if ((geographicalExtent = node.path("geographicalExtent")).isArray() && geographicalExtent.size() > 5) {
            ArrayList<Double> extent = new ArrayList<Double>();
            for (int i = 0; i < 6; ++i) {
                extent.add(geographicalExtent.path(i).asDouble());
            }
            object.setGeographicalExtent(extent);
        }
        if ((referenceSystem = node.path("referenceSystem")).isTextual()) {
            object.setReferenceSystem(ReferenceSystem.parse(referenceSystem.asText()));
        }
    }

    @Override
    public void writeObject(Metadata object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        String propertyName;
        CityJSONVersion version = helper.getVersion();
        if (object.getIdentifier() != null) {
            propertyName = version == CityJSONVersion.v1_0 ? "fileIdentifier" : "identifier";
            node.put(propertyName, object.getIdentifier());
        }
        if (object.getPointOfContact() != null) {
            propertyName = version == CityJSONVersion.v1_0 ? "datasetPointOfContact" : "pointOfContact";
            node.set(propertyName, (JsonNode)helper.getObjectUsingSerializer(object.getPointOfContact(), PointOfContactAdapter.class));
        }
        if (object.getReferenceDate() != null) {
            propertyName = version == CityJSONVersion.v1_0 ? "datasetReferenceDate" : "referenceDate";
            node.put(propertyName, object.getReferenceDate().format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
        if (object.getTitle() != null) {
            propertyName = version == CityJSONVersion.v1_0 ? "datasetTitle" : "title";
            node.put(propertyName, object.getTitle());
        }
        if (object.isSetGeographicalExtent()) {
            ArrayNode geographicalExtent = node.putArray("geographicalExtent");
            object.getGeographicalExtent().forEach(arg_0 -> ((ArrayNode)geographicalExtent).add(arg_0));
        }
        if (object.getReferenceSystem() != null) {
            node.put("referenceSystem", object.getReferenceSystem().toURI(version));
        }
    }
}

