/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.metadata.ContactType;
import org.citygml4j.cityjson.model.metadata.PointOfContact;
import org.citygml4j.cityjson.model.metadata.Role;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;

public class PointOfContactAdapter
implements JsonObjectBuilder<PointOfContact>,
JsonObjectSerializer<PointOfContact> {
    @Override
    public PointOfContact createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new PointOfContact();
    }

    @Override
    public void buildObject(PointOfContact object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        JsonNode website;
        JsonNode organization;
        JsonNode role;
        JsonNode contactType;
        JsonNode emailAddress;
        JsonNode address;
        JsonNode phone;
        JsonNode contactName = node.path("contactName");
        if (contactName.isTextual() && !contactName.asText().isEmpty()) {
            object.setContactName(contactName.asText());
        }
        if ((phone = node.path("phone")).isTextual()) {
            object.setPhone(phone.asText());
        }
        if ((address = node.path("address")).isTextual()) {
            object.setAddress(address.asText());
        }
        if ((emailAddress = node.path("emailAddress")).isTextual()) {
            object.setEmailAddress(emailAddress.asText());
        }
        if ((contactType = node.path("contactType")).isTextual()) {
            object.setContactType(ContactType.fromValue(contactType.asText()));
        }
        if ((role = node.path("role")).isTextual()) {
            object.setRole(Role.fromValue(role.asText()));
        }
        if ((organization = node.path("organization")).isTextual()) {
            object.setOrganization(organization.asText());
        }
        if ((website = node.path("website")).isTextual()) {
            object.setWebsite(website.asText());
        }
    }

    @Override
    public void writeObject(PointOfContact object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        CityJSONVersion version = helper.getVersion();
        if (object.getContactName() != null) {
            node.put("contactName", object.getContactName());
        } else if (version == CityJSONVersion.v1_1) {
            node.put("contactName", "");
        }
        if (object.getPhone() != null) {
            node.put("phone", object.getPhone());
        }
        if (object.getAddress() != null) {
            node.put("address", object.getAddress());
        }
        if (object.getEmailAddress() != null) {
            node.put("emailAddress", object.getEmailAddress());
        } else if (version == CityJSONVersion.v1_1) {
            node.put("emailAddress", "");
        }
        if (object.getContactType() != null) {
            node.put("contactType", object.getContactType().toValue());
            if (version == CityJSONVersion.v1_0) {
                if (object.getContactType() == ContactType.INDIVIDUAL) {
                    if (object.getRole() != null) {
                        node.put("role", object.getRole().toValue());
                    }
                    if (object.getOrganization() != null) {
                        node.put("organization", object.getOrganization());
                    }
                } else if (object.getWebsite() != null) {
                    node.put("website", object.getWebsite());
                }
            }
        }
        if (version == CityJSONVersion.v1_1) {
            if (object.getRole() != null) {
                node.put("role", object.getRole().toValue());
            }
            if (object.getOrganization() != null) {
                node.put("organization", object.getOrganization());
            }
            if (object.getWebsite() != null) {
                node.put("website", object.getWebsite());
            }
        }
    }
}

