/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.model.geometry;

import java.util.EnumSet;

public enum GeometryType {
    MULTI_POINT("MultiPoint"),
    MULTI_LINE_STRING("MultiLineString"),
    MULTI_SURFACE("MultiSurface"),
    COMPOSITE_SURFACE("CompositeSurface"),
    SOLID("Solid"),
    MULTI_SOLID("MultiSolid"),
    COMPOSITE_SOLID("CompositeSolid"),
    TEMPLATE_GEOMETRY("GeometryInstance");

    public static final EnumSet<GeometryType> SURFACE_TYPES;
    public static final EnumSet<GeometryType> SOLID_TYPES;
    private final String typeName;

    private GeometryType(String typeName) {
        this.typeName = typeName;
    }

    public String toTypeName() {
        return this.typeName;
    }

    public static GeometryType fromValue(String value) {
        for (GeometryType v : GeometryType.values()) {
            if (!v.toTypeName().equals(value)) continue;
            return v;
        }
        return null;
    }

    public String toString() {
        return this.typeName;
    }

    static {
        SURFACE_TYPES = EnumSet.of(MULTI_SURFACE, COMPOSITE_SURFACE);
        SOLID_TYPES = EnumSet.of(SOLID, COMPOSITE_SOLID, MULTI_SOLID);
    }
}

