/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.reader;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.reader.CityJSONReader;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.core.AbstractFeature;
import org.xmlobjects.gml.visitor.Visitable;

public class CityJSONChunkReader
extends CityJSONReader {
    private final Deque<Appearance> globalAppearances = new ArrayDeque<Appearance>();
    private AbstractFeature next;
    private CityJSONBuilderHelper helper;
    private CityJSONReader.TopLevelIterator iterator;

    CityJSONChunkReader(JsonParser reader, ObjectMapper mapper, CityJSONContext context) {
        super(reader, mapper, context);
    }

    @Override
    public boolean hasNext() throws CityJSONReadException {
        if (this.next == null) {
            try {
                while (this.next == null && !this.topLevelObjects.isEmpty()) {
                    String nested = (String)this.topLevelObjects.pop();
                    JsonNode node = this.helper.getCityObjects().path(nested);
                    if (!node.isObject()) continue;
                    this.next = this.processCityObject(node, nested);
                    this.helper.getCityObjects().remove(nested);
                }
                while (this.next == null && this.updateTopLevelIterator()) {
                    if (!this.iterator.hasNext()) continue;
                    Object entry = this.iterator.next();
                    this.next = this.processCityObject((JsonNode)entry.getValue(), (String)entry.getKey());
                }
                while (this.next == null && !this.globalAppearances.isEmpty()) {
                    this.next = (AbstractFeature)this.globalAppearances.pop();
                }
            }
            catch (CityJSONBuildException e) {
                throw new CityJSONReadException("Caused by:", e);
            }
        }
        return this.next != null;
    }

    @Override
    public AbstractFeature next() throws CityJSONReadException {
        if (this.hasNext()) {
            try {
                if (this.resolver != null) {
                    this.resolver.resolveReferences(new Visitable[]{this.next});
                }
                AbstractFeature abstractFeature = this.next;
                return abstractFeature;
            }
            finally {
                this.next = null;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void close() throws CityJSONReadException {
        try {
            super.close();
        }
        finally {
            this.globalAppearances.clear();
            this.helper = null;
            this.iterator = null;
        }
    }

    private AbstractFeature processCityObject(JsonNode topLevelObject, String identifier) throws CityJSONReadException, CityJSONBuildException {
        AbstractFeature object = this.helper.getObject(topLevelObject, AbstractFeature.class);
        this.helper.removeChildren(topLevelObject, identifier, !this.topLevelObjects.isEmpty() ? new HashSet(this.topLevelObjects) : Collections.emptySet());
        if (object != null) {
            object.setId(identifier);
        }
        return object;
    }

    private boolean updateTopLevelIterator() throws CityJSONReadException {
        if (this.iterator == null || !this.iterator.hasNext()) {
            try {
                TreeNode node;
                if (this.helper != null && this.helper.hasGlobalAppearances()) {
                    this.globalAppearances.addAll(this.helper.getGlobalAppearances());
                }
                this.helper = null;
                this.iterator = null;
                if (this.globalAppearances.isEmpty() && (node = this.objectMapper.readTree(this.reader)) != null && node.isObject()) {
                    ObjectNode content = (ObjectNode)node;
                    this.helper = this.createHelper(content);
                    this.iterator = CityJSONReader.TopLevelIterator.of(this.helper, this.filter);
                }
                return this.iterator != null;
            }
            catch (IOException | CityJSONBuildException e) {
                throw new CityJSONReadException("Caused by:", e);
            }
        }
        return true;
    }
}

