/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.reader;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.reader.CityJSONChunkReader;
import org.citygml4j.cityjson.reader.CityJSONInputFilter;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.reader.CityJSONReader;
import org.citygml4j.cityjson.reader.CityJSONSimpleReader;
import org.citygml4j.cityjson.util.lod.LodMapper;
import org.citygml4j.cityjson.util.texture.DefaultTextureFileHandler;
import org.citygml4j.cityjson.util.texture.TextureFileHandler;
import org.citygml4j.core.model.CityGMLVersion;
import org.xmlobjects.gml.util.id.IdCreator;
import org.xmlobjects.gml.util.reference.ReferenceResolver;
import org.xmlobjects.util.Properties;

public class CityJSONInputFactory {
    private final ObjectMapper objectMapper;
    private final CityJSONContext context;
    private final Properties properties = new Properties();
    private CityGMLVersion targetCityGMLVersion = CityGMLVersion.v3_0;
    private boolean chunkByTopLevelCityObjects;
    private boolean mapUnsupportedTypesToGenerics = true;
    private boolean transformTemplateGeometries;
    private boolean assignAppearancesToImplicitGeometries;
    private ReferenceResolver resolver;
    private LodMapper lodMapper;
    private IdCreator idCreator;

    public CityJSONInputFactory(ObjectMapper objectMapper, CityJSONContext context) {
        this.objectMapper = objectMapper;
        this.context = context;
        this.withTextureFileHandler(new DefaultTextureFileHandler());
    }

    public CityGMLVersion getTargetCityGMLVersion() {
        return this.targetCityGMLVersion;
    }

    public CityJSONInputFactory withTargetCityGMLVersion(CityGMLVersion targetCityGMLVersion) {
        this.targetCityGMLVersion = targetCityGMLVersion;
        return this;
    }

    public boolean isChunkByTopLevelCityObjects() {
        return this.chunkByTopLevelCityObjects;
    }

    public CityJSONInputFactory chunkByTopLevelCityObjects(boolean chunkByTopLevelCityObjects) {
        this.chunkByTopLevelCityObjects = chunkByTopLevelCityObjects;
        return this;
    }

    public boolean isMapUnsupportedTypesToGenerics() {
        return this.mapUnsupportedTypesToGenerics;
    }

    public CityJSONInputFactory mapUnsupportedTypesToGenerics(boolean mapUnsupportedTypesToGenerics) {
        this.mapUnsupportedTypesToGenerics = mapUnsupportedTypesToGenerics;
        return this;
    }

    public boolean isTransformTemplateGeometries() {
        return this.transformTemplateGeometries;
    }

    public CityJSONInputFactory transformTemplateGeometries(boolean transformTemplateGeometries) {
        this.transformTemplateGeometries = transformTemplateGeometries;
        return this;
    }

    public boolean isAssignAppearancesToImplicitGeometries() {
        return this.assignAppearancesToImplicitGeometries;
    }

    public CityJSONInputFactory assignAppearancesToImplicitGeometries(boolean assignAppearancesToImplicitGeometries) {
        this.assignAppearancesToImplicitGeometries = assignAppearancesToImplicitGeometries;
        return this;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.resolver;
    }

    public CityJSONInputFactory withReferenceResolver(ReferenceResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public LodMapper getLodMapper() {
        return this.lodMapper;
    }

    public CityJSONInputFactory withLodMapper(LodMapper lodMapper) {
        this.lodMapper = Objects.requireNonNull(lodMapper, "The LoD mapper must not be null.");
        return this;
    }

    public IdCreator getIdCreator() {
        return this.idCreator;
    }

    public CityJSONInputFactory withIdCreator(IdCreator idCreator) {
        this.idCreator = Objects.requireNonNull(idCreator, "The ID creator must not be null.");
        return this;
    }

    public TextureFileHandler getTextureFileHandler() {
        return (TextureFileHandler)this.properties.get(TextureFileHandler.class.getName(), TextureFileHandler.class);
    }

    public CityJSONInputFactory withTextureFileHandler(TextureFileHandler textureFileHandler) {
        Objects.requireNonNull(textureFileHandler, "The texture file handler must not be null.");
        this.withProperty(TextureFileHandler.class.getName(), textureFileHandler);
        return this;
    }

    public String getCodeSpaceForIdentifiers(String codeSpace) {
        return (String)this.properties.get("org.citygml4j.cityjson.idCodeSpace", String.class);
    }

    public CityJSONInputFactory withCodeSpaceForIdentifiers(String codeSpace) {
        this.withProperty("org.citygml4j.cityjson.idCodeSpace", codeSpace);
        return this;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public CityJSONInputFactory withProperty(String name, Object value) {
        this.properties.set(name, value);
        return this;
    }

    public CityJSONReader createCityJSONReader(File file) throws CityJSONReadException {
        try {
            return this.createReader(this.objectMapper.createParser(file));
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by:", e);
        }
    }

    public CityJSONReader createCityJSONReader(File file, String encoding) throws CityJSONReadException {
        try {
            return this.createReader(this.objectMapper.createParser((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding))));
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by:", e);
        }
    }

    public CityJSONReader createCityJSONReader(Path path) throws CityJSONReadException {
        try {
            return this.createReader(this.objectMapper.createParser((InputStream)new BufferedInputStream(Files.newInputStream(path, new OpenOption[0]))));
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by:", e);
        }
    }

    public CityJSONReader createCityJSONReader(Path path, String encoding) throws CityJSONReadException {
        try {
            return this.createReader(this.objectMapper.createParser((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), encoding))));
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by:", e);
        }
    }

    public CityJSONReader createCityJSONReader(URL url) throws CityJSONReadException {
        try {
            return this.createReader(this.objectMapper.createParser(url));
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by:", e);
        }
    }

    public CityJSONReader createCityJSONReader(InputStream stream) throws CityJSONReadException {
        try {
            return this.createReader(this.objectMapper.createParser(stream));
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by:", e);
        }
    }

    public CityJSONReader createCityJSONReader(Reader reader) throws CityJSONReadException {
        try {
            return this.createReader(this.objectMapper.createParser(reader));
        }
        catch (IOException e) {
            throw new CityJSONReadException("Caused by:", e);
        }
    }

    public CityJSONReader createFilteredCityJSONReader(CityJSONReader reader, CityJSONInputFilter filter) {
        reader.filter = filter;
        return reader;
    }

    private CityJSONReader createReader(JsonParser jsonReader) throws CityJSONReadException {
        CityJSONReader reader = this.chunkByTopLevelCityObjects ? new CityJSONChunkReader(jsonReader, this.objectMapper, this.context) : new CityJSONSimpleReader(jsonReader, this.objectMapper, this.context);
        reader.targetCityGMLVersion = this.targetCityGMLVersion;
        reader.mapUnsupportedTypesToGenerics = this.mapUnsupportedTypesToGenerics;
        reader.transformTemplateGeometries = this.transformTemplateGeometries;
        reader.assignAppearancesToImplicitGeometries = this.targetCityGMLVersion == CityGMLVersion.v3_0 && this.assignAppearancesToImplicitGeometries;
        reader.resolver = this.resolver;
        reader.lodMapper = this.lodMapper;
        reader.idCreator = this.idCreator;
        reader.properties = this.properties;
        return reader;
    }
}

