/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.reader;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.citygml4j.cityjson.CityJSONContext;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.reader.CityJSONReader;
import org.citygml4j.core.model.ade.ADEProperty;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.common.TopLevelFeature;
import org.citygml4j.core.model.core.ADEOfCityModel;
import org.citygml4j.core.model.core.AbstractAppearance;
import org.citygml4j.core.model.core.AbstractAppearanceProperty;
import org.citygml4j.core.model.core.AbstractCityObject;
import org.citygml4j.core.model.core.AbstractCityObjectProperty;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.model.core.AbstractFeatureProperty;
import org.citygml4j.core.model.core.CityModel;
import org.xmlobjects.gml.model.feature.BoundingShape;
import org.xmlobjects.gml.model.geometry.DirectPosition;
import org.xmlobjects.gml.model.geometry.Envelope;
import org.xmlobjects.gml.visitor.Visitable;

public class CityJSONSimpleReader
extends CityJSONReader {
    private boolean hasNext = false;
    private CityModel cityModel;

    CityJSONSimpleReader(JsonParser reader, ObjectMapper mapper, CityJSONContext context) {
        super(reader, mapper, context);
    }

    @Override
    public boolean hasNext() throws CityJSONReadException {
        if (!this.hasNext) {
            try {
                TreeNode node;
                this.cityModel = new CityModel();
                while ((node = this.objectMapper.readTree(this.reader)) != null && node.isObject()) {
                    ObjectNode content = (ObjectNode)node;
                    CityJSONBuilderHelper helper = this.createHelper(content);
                    CityJSONReader.TopLevelIterator iterator = CityJSONReader.TopLevelIterator.of(helper, this.filter);
                    while (iterator.hasNext()) {
                        Object entry = iterator.next();
                        this.processCityObject((JsonNode)entry.getValue(), (String)entry.getKey(), helper);
                    }
                    if ((this.cityModel.isSetCityObjectMembers() || this.cityModel.isSetFeatureMembers()) && helper.hasGlobalAppearances()) {
                        for (Appearance appearance : helper.getGlobalAppearances()) {
                            this.cityModel.getAppearanceMembers().add(new AbstractAppearanceProperty((AbstractAppearance)appearance));
                        }
                    }
                    this.hasNext = true;
                }
                if (this.hasNext) {
                    List<Double> geographicalExtent;
                    if (this.metadata != null && this.metadata.isSetGeographicalExtent() && (geographicalExtent = this.metadata.getGeographicalExtent()).size() > 5) {
                        Envelope envelope = new Envelope(new DirectPosition(geographicalExtent.subList(0, 3)), new DirectPosition(geographicalExtent.subList(3, 6)));
                        envelope.setSrsDimension(Integer.valueOf(3));
                        if (this.metadata.getReferenceSystem() != null) {
                            envelope.setSrsName(this.metadata.getReferenceSystem().toURL());
                        }
                        this.cityModel.setBoundedBy(new BoundingShape(envelope));
                    }
                    if (this.extraRootProperties != null) {
                        for (ADEOfCityModel property : this.extraRootProperties.values()) {
                            this.cityModel.addADEProperty((ADEProperty)property);
                        }
                    }
                }
            }
            catch (IOException | CityJSONBuildException e) {
                throw new CityJSONReadException("Caused by:", e);
            }
        }
        return this.hasNext;
    }

    @Override
    public AbstractFeature next() throws CityJSONReadException {
        if (this.hasNext()) {
            try {
                if (this.resolver != null) {
                    this.resolver.resolveReferences(new Visitable[]{this.cityModel});
                }
                CityModel cityModel = this.cityModel;
                return cityModel;
            }
            finally {
                this.hasNext = false;
                this.cityModel = null;
            }
        }
        throw new NoSuchElementException();
    }

    private void processCityObject(JsonNode topLevelObject, String identifier, CityJSONBuilderHelper helper) throws CityJSONReadException, CityJSONBuildException {
        AbstractFeature object = helper.getObject(topLevelObject, AbstractFeature.class);
        helper.removeChildren(topLevelObject, identifier, !this.topLevelObjects.isEmpty() ? new HashSet(this.topLevelObjects) : Collections.emptySet());
        while (!this.topLevelObjects.isEmpty()) {
            String nested = (String)this.topLevelObjects.pop();
            JsonNode node = helper.getCityObjects().path(nested);
            if (!node.isObject()) continue;
            this.processCityObject(node, nested, helper);
            helper.getCityObjects().remove(nested);
        }
        if (object != null) {
            object.setId(identifier);
            if (object instanceof AbstractCityObject && object instanceof TopLevelFeature) {
                this.cityModel.getCityObjectMembers().add(new AbstractCityObjectProperty((AbstractCityObject)object));
            } else {
                this.cityModel.getFeatureMembers().add(new AbstractFeatureProperty(object));
            }
        }
    }
}

