/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.writer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.citygml4j.cityjson.ExtensionLoader;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceSerializer;
import org.citygml4j.cityjson.adapter.extension.ExtensionInfo;
import org.citygml4j.cityjson.adapter.extension.ExtensionInfoAdapter;
import org.citygml4j.cityjson.adapter.geometry.serializer.GeometrySerializer;
import org.citygml4j.cityjson.adapter.metadata.MetadataAdapter;
import org.citygml4j.cityjson.extension.Extension;
import org.citygml4j.cityjson.model.CityJSONVersion;
import org.citygml4j.cityjson.model.generics.GenericAttributeTypes;
import org.citygml4j.cityjson.model.geometry.TextureVertex;
import org.citygml4j.cityjson.model.geometry.Transform;
import org.citygml4j.cityjson.model.geometry.Vertex;
import org.citygml4j.cityjson.model.metadata.Metadata;
import org.citygml4j.cityjson.model.metadata.ReferenceSystem;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.util.ArrayBuffer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.cityjson.writer.HtmlEscapes;
import org.citygml4j.core.ade.ADERegistry;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.cityobjectgroup.CityObjectGroup;
import org.citygml4j.core.model.core.ADEOfCityModel;
import org.citygml4j.core.model.core.AbstractFeature;
import org.citygml4j.core.util.reference.DefaultReferenceResolver;
import org.xmlobjects.gml.model.geometry.AbstractGeometry;
import org.xmlobjects.gml.util.reference.ReferenceResolver;
import org.xmlobjects.gml.visitor.Visitable;

public abstract class AbstractCityJSONWriter<T extends AbstractCityJSONWriter<?>>
implements AutoCloseable {
    final JsonGenerator writer;
    final ReferenceResolver referenceResolver;
    final Deque<Visitable> resolveScopes = new ArrayDeque<Visitable>();
    CityJSONSerializerHelper helper;
    State state = State.INITIAL;

    AbstractCityJSONWriter(JsonGenerator writer) {
        this.writer = writer;
        this.referenceResolver = DefaultReferenceResolver.newInstance().storeRefereesWithReferencedObject(true);
    }

    abstract void writeCityObject(String var1, ObjectNode var2) throws CityJSONWriteException;

    abstract void writeChildObject(String var1, ObjectNode var2) throws CityJSONWriteException;

    public Metadata getMetadata() {
        return this.helper.getMetadata();
    }

    public T withMetadata(Metadata metadata) {
        this.helper.setMetadata(metadata);
        return (T)this;
    }

    public T withGlobalCityObjectGroup(CityObjectGroup group) {
        this.resolveScopes.push((Visitable)Objects.requireNonNull(group, "The city object group must not be null."));
        return (T)this;
    }

    public T withGlobalAppearance(Appearance appearance) {
        this.resolveScopes.push((Visitable)Objects.requireNonNull(appearance, "The appearance must not be null."));
        return (T)this;
    }

    public T withGlobalTemplateGeometry(AbstractGeometry geometry) {
        Objects.requireNonNull(geometry, "The template geometry must not be null.");
        if (geometry.getId() != null) {
            this.resolveScopes.push((Visitable)geometry);
        }
        return (T)this;
    }

    public T withExtraRootProperty(ADEOfCityModel property) throws CityJSONWriteException {
        try {
            this.helper.addExtraRootProperty(property);
            return (T)this;
        }
        catch (CityJSONSerializeException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    public T withExtraRootProperty(String propertyName, JsonNode value) {
        this.helper.addExtraRootProperty(propertyName, value);
        return (T)this;
    }

    public boolean isHtmlSafe() {
        return this.writer.getCharacterEscapes() instanceof HtmlEscapes;
    }

    public T setHtmlSafe(boolean htmlSafe) {
        this.writer.setCharacterEscapes((CharacterEscapes)(htmlSafe ? new HtmlEscapes() : null));
        return (T)this;
    }

    void beginTopLevelObject() {
    }

    public void writeCityObject(AbstractFeature feature) throws CityJSONWriteException {
        if (feature != null) {
            try {
                this.resolveScopes.push((Visitable)feature);
                this.referenceResolver.resolveReferences(this.resolveScopes);
                this.helper.writeCityObject(feature);
                this.referenceResolver.removeResolvedReferences(this.resolveScopes);
                this.resolveScopes.pop();
            }
            catch (CityJSONSerializeException e) {
                throw new CityJSONWriteException("Caused by:", e);
            }
        }
    }

    public void flush() throws CityJSONWriteException {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
    }

    @Override
    public void close() throws CityJSONWriteException {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
        finally {
            this.helper.reset();
            this.resolveScopes.clear();
        }
    }

    void writeVertices(boolean writeTransform) throws IOException {
        GeometrySerializer geometrySerializer = this.helper.getGeometrySerializer();
        ArrayBuffer<Vertex> vertices = geometrySerializer.getVerticesBuilder().build();
        if (!vertices.isEmpty()) {
            if (this.helper.isComputeCityModelExtent()) {
                this.helper.getMetadata().setGeographicalExtent(this.helper.computeExtent(vertices));
            }
            if (this.helper.getVersion() != CityJSONVersion.v1_0 || this.helper.isApplyTransformation()) {
                Transform transform = geometrySerializer.getVerticesBuilder().transform();
                if (writeTransform) {
                    this.writeTransform(transform);
                }
                this.writeTransformedVertices("vertices", vertices);
            } else {
                this.writeVertices("vertices", vertices);
            }
        } else {
            if (this.helper.getVersion() == CityJSONVersion.v1_1) {
                this.writeTransform(new Transform());
            }
            this.writer.writeArrayFieldStart("vertices");
            this.writer.writeEndArray();
        }
    }

    void writeTransform(Transform transform) throws IOException {
        Vertex scale = transform.getScale();
        Vertex translate = transform.getTranslate();
        this.writer.writeObjectFieldStart("transform");
        this.writer.writeArrayFieldStart("scale");
        this.writer.writeNumber(scale.getX());
        this.writer.writeNumber(scale.getY());
        this.writer.writeNumber(scale.getZ());
        this.writer.writeEndArray();
        this.writer.writeArrayFieldStart("translate");
        this.writer.writeNumber(translate.getX());
        this.writer.writeNumber(translate.getY());
        this.writer.writeNumber(translate.getZ());
        this.writer.writeEndArray();
        this.writer.writeEndObject();
    }

    void writeExtensions() throws CityJSONWriteException, IOException {
        ExtensionLoader loader = (ExtensionLoader)ADERegistry.getInstance().getADELoader(ExtensionLoader.class);
        if (loader.hasExtensions() || this.helper.hasExtensions()) {
            try {
                this.writer.writeObjectFieldStart("extensions");
                for (Extension extension : loader.getExtensions()) {
                    ObjectNode node = this.helper.getObjectUsingSerializer(ExtensionInfo.of(extension), ExtensionInfoAdapter.class);
                    if (node == null) continue;
                    this.writer.writeObjectField(extension.getName(), (Object)node);
                }
                for (Map.Entry entry : this.helper.getExternalExtensions().entrySet()) {
                    if (loader.getExtension((String)entry.getKey()) != null) continue;
                    this.writer.writeObjectField((String)entry.getKey(), entry.getValue());
                }
                this.writer.writeEndObject();
            }
            catch (CityJSONSerializeException e) {
                throw new CityJSONWriteException("Failed to serialize the extensions property.", e);
            }
        }
    }

    void writeMetadata() throws CityJSONWriteException, IOException {
        if (this.helper.hasMetadata()) {
            try {
                ObjectNode metadata = this.helper.getObjectUsingSerializer(this.helper.getMetadata(), MetadataAdapter.class);
                if (!metadata.isEmpty()) {
                    this.writer.writeObjectField("metadata", (Object)metadata);
                }
            }
            catch (CityJSONSerializeException e) {
                throw new CityJSONWriteException("Failed to serialize the metadata property.", e);
            }
        }
    }

    void writeAppearance() throws IOException {
        AppearanceSerializer appearanceSerializer = this.helper.getAppearanceSerializer();
        if (appearanceSerializer.hasMaterials() || appearanceSerializer.hasTextures()) {
            this.writer.writeObjectFieldStart("appearance");
            if (appearanceSerializer.hasMaterials()) {
                this.writeAsArray("materials", appearanceSerializer.getMaterials());
            }
            if (appearanceSerializer.hasTextures()) {
                this.writeAsArray("textures", appearanceSerializer.getTextures());
                ArrayBuffer<TextureVertex> textureVertices = appearanceSerializer.getTextureVerticesBuilder().build();
                if (!textureVertices.isEmpty()) {
                    this.writer.writeArrayFieldStart("vertices-texture");
                    for (TextureVertex textureVertex : textureVertices) {
                        this.writer.writeStartArray();
                        this.writer.writeNumber(textureVertex.getS());
                        this.writer.writeNumber(textureVertex.getT());
                        this.writer.writeEndArray();
                    }
                    this.writer.writeEndArray();
                }
            }
            this.writer.writeEndObject();
        }
    }

    void writeTemplates() throws IOException {
        GeometrySerializer geometrySerializer = this.helper.getGeometrySerializer();
        if (geometrySerializer.hasTemplates()) {
            this.writer.writeObjectFieldStart("geometry-templates");
            this.writeAsArray("templates", geometrySerializer.getTemplates());
            this.writeVertices("vertices-templates", geometrySerializer.getTemplatesVerticesBuilder().build());
            this.writer.writeEndObject();
        }
    }

    void writeExtraRootProperties() throws IOException {
        if (this.helper.isWriteGenericAttributeTypes()) {
            try {
                this.helper.addExtraRootProperty((ADEOfCityModel)this.helper.getProperties().get(GenericAttributeTypes.class.getName(), ADEOfCityModel.class));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.helper.hasExtraRootProperties()) {
            Iterator iterator = this.helper.getExtraRootProperties().fields();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                this.writer.writeObjectField((String)entry.getKey(), entry.getValue());
            }
        }
    }

    void writeAsArray(String propertyName, Iterator<ObjectNode> iterator) throws IOException {
        this.writer.writeArrayFieldStart(propertyName);
        while (iterator.hasNext()) {
            this.writer.writeObject((Object)iterator.next());
        }
        this.writer.writeEndArray();
    }

    void writeVertices(String propertyName, ArrayBuffer<Vertex> vertices) throws IOException {
        this.writer.writeArrayFieldStart(propertyName);
        for (Vertex vertex : vertices) {
            this.writer.writeStartArray();
            this.writer.writeNumber(vertex.getX());
            this.writer.writeNumber(vertex.getY());
            this.writer.writeNumber(vertex.getZ());
            this.writer.writeEndArray();
        }
        this.writer.writeEndArray();
    }

    void writeTransformedVertices(String propertyName, ArrayBuffer<Vertex> vertices) throws IOException {
        this.writer.writeArrayFieldStart(propertyName);
        for (Vertex vertex : vertices) {
            this.writer.writeStartArray();
            this.writer.writeNumber((long)vertex.getX());
            this.writer.writeNumber((long)vertex.getY());
            this.writer.writeNumber((long)vertex.getZ());
            this.writer.writeEndArray();
        }
        this.writer.writeEndArray();
    }

    void getAndSetReferenceSystem(AbstractFeature feature) {
        String referenceSystem;
        if (!(feature == null || this.helper.hasMetadata() && this.helper.getMetadata().getReferenceSystem() != null || (referenceSystem = this.helper.getReferenceSystem(feature)) == null)) {
            this.helper.getMetadata().setReferenceSystem(ReferenceSystem.parse(referenceSystem));
        }
    }

    static enum State {
        INITIAL,
        DOCUMENT_STARTED,
        CLOSED;

    }
}

