/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.writer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.citygml4j.cityjson.adapter.geometry.serializer.VerticesBuilder;
import org.citygml4j.cityjson.model.CityJSONType;
import org.citygml4j.cityjson.model.geometry.Transform;
import org.citygml4j.cityjson.model.geometry.Vertex;
import org.citygml4j.cityjson.writer.AbstractCityJSONWriter;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.citygml4j.core.model.cityobjectgroup.CityObjectGroup;
import org.citygml4j.core.model.core.AbstractFeature;
import org.xmlobjects.gml.model.geometry.Envelope;
import org.xmlobjects.gml.visitor.Visitable;

public class CityJSONFeatureWriter
extends AbstractCityJSONWriter<CityJSONFeatureWriter> {
    private final Deque<ObjectNode> topLevelObjects = new ArrayDeque<ObjectNode>();

    CityJSONFeatureWriter(JsonGenerator writer) {
        super(writer);
        writer.setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter("\n"));
    }

    public boolean isSetExternalExtension(String name) {
        return this.helper.isSetExternalExtension(name);
    }

    public void addExternalExtension(String name, String url, String version) {
        this.helper.addExternalExtension(name, url, version);
    }

    public Vertex getTranslation() {
        return this.helper.getGeometrySerializer().getVerticesBuilder().getTranslation();
    }

    public CityJSONFeatureWriter withTranslation(Vertex translation) {
        Objects.requireNonNull(translation, "Translation must not be null.");
        this.helper.getGeometrySerializer().getVerticesBuilder().setTranslation(translation);
        return this;
    }

    private void writeStartDocument(AbstractFeature feature) throws CityJSONWriteException {
        if (this.state != AbstractCityJSONWriter.State.INITIAL) {
            throw new CityJSONWriteException("The document has already been started.");
        }
        try {
            this.writer.writeStartObject();
            this.writer.writeStringField("type", CityJSONType.CITYJSON.toTypeName());
            this.writer.writeStringField("version", this.helper.getVersion().toValue());
            this.writer.writeObjectFieldStart("CityObjects");
            this.writer.writeEndObject();
            this.writer.writeArrayFieldStart("vertices");
            this.writer.writeEndArray();
            this.writeTransform(this.computeTransform(feature));
            this.writeExtensions();
            this.getAndSetReferenceSystem(feature);
            this.writeMetadata();
            this.writer.writeEndObject();
        }
        catch (IOException e) {
            throw new CityJSONWriteException("Caused by:", e);
        }
        finally {
            this.state = AbstractCityJSONWriter.State.DOCUMENT_STARTED;
        }
    }

    @Override
    public void writeCityObject(AbstractFeature feature) throws CityJSONWriteException {
        switch (this.state) {
            case CLOSED: {
                throw new CityJSONWriteException("Illegal to write city objects after writer has been closed.");
            }
            case INITIAL: {
                this.writeStartDocument(feature);
            }
        }
        super.writeCityObject(feature);
    }

    @Override
    void beginTopLevelObject() {
        this.topLevelObjects.push(this.helper.createObject());
    }

    @Override
    void writeCityObject(String id, ObjectNode node) throws CityJSONWriteException {
        ObjectNode topLevelObject = this.topLevelObjects.pop();
        if (topLevelObject != null) {
            try {
                topLevelObject.set(id, (JsonNode)node);
                this.writer.writeStartObject();
                this.writer.writeStringField("type", CityJSONType.CITYJSON_FEATURE.toTypeName());
                this.writer.writeStringField("id", id);
                this.writer.writeObjectField("CityObjects", (Object)topLevelObject);
                this.writeVertices(false);
                this.writeAppearance();
                this.writer.writeEndObject();
            }
            catch (IOException e) {
                throw new CityJSONWriteException("Caused by:", e);
            }
            finally {
                this.helper.reset();
            }
        }
    }

    @Override
    void writeChildObject(String id, ObjectNode node) throws CityJSONWriteException {
        ObjectNode topLevelObject = this.topLevelObjects.peek();
        if (topLevelObject != null) {
            topLevelObject.set(id, (JsonNode)node);
        }
    }

    private void writeEndDocument() throws CityJSONWriteException {
        if (this.state == AbstractCityJSONWriter.State.INITIAL) {
            this.writeStartDocument(null);
        }
        if (this.state == AbstractCityJSONWriter.State.DOCUMENT_STARTED) {
            for (Visitable visitable : this.resolveScopes) {
                if (!(visitable instanceof CityObjectGroup)) continue;
                if (this.state == AbstractCityJSONWriter.State.INITIAL) {
                    this.writeStartDocument((AbstractFeature)((CityObjectGroup)visitable));
                }
                this.writeCityObject((AbstractFeature)((CityObjectGroup)visitable));
            }
        }
    }

    @Override
    public void close() throws CityJSONWriteException {
        if (this.state == AbstractCityJSONWriter.State.CLOSED) {
            throw new CityJSONWriteException("The writer has already been closed.");
        }
        try {
            this.writeEndDocument();
            super.close();
        }
        finally {
            this.state = AbstractCityJSONWriter.State.CLOSED;
        }
    }

    private Transform computeTransform(AbstractFeature feature) {
        VerticesBuilder builder = this.helper.getGeometrySerializer().getVerticesBuilder();
        Transform transform = new Transform();
        double scale = 1.0 / Math.pow(10.0, builder.getPrecision());
        transform.setScale(Vertex.of(scale, scale, scale));
        if (feature != null && builder.getTranslation() == null) {
            Envelope envelope = feature.computeEnvelope();
            List lowerCorner = envelope.getLowerCorner().toCoordinateList3D();
            if (!lowerCorner.isEmpty()) {
                transform.setTranslate(Vertex.of(builder.round((Double)lowerCorner.get(0)), builder.round((Double)lowerCorner.get(1)), builder.round((Double)lowerCorner.get(2))));
            }
            builder.setTranslation(transform.getTranslate());
        }
        return transform;
    }
}

