/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.address;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.citygml4j.cityjson.builder.CityJSONBuildException;
import org.citygml4j.cityjson.builder.JsonObjectBuilder;
import org.citygml4j.cityjson.model.address.AddressType;
import org.citygml4j.cityjson.reader.Attributes;
import org.citygml4j.cityjson.reader.CityJSONBuilderHelper;
import org.citygml4j.cityjson.reader.CityJSONReadException;
import org.citygml4j.cityjson.serializer.CityJSONSerializeException;
import org.citygml4j.cityjson.serializer.JsonObjectSerializer;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.cityjson.writer.CityJSONWriteException;
import org.xmlobjects.xal.model.Locality;
import org.xmlobjects.xal.model.types.LocalityName;
import org.xmlobjects.xal.model.types.LocalityNameType;
import org.xmlobjects.xal.model.types.NameType;

public class LocalityAdapter
implements JsonObjectBuilder<Locality>,
JsonObjectSerializer<Locality> {
    @Override
    public Locality createObject(JsonNode node, Object parent) throws CityJSONBuildException {
        return new Locality();
    }

    @Override
    public void buildObject(Locality object, Attributes attributes, JsonNode node, Object parent, CityJSONBuilderHelper helper) throws CityJSONBuildException, CityJSONReadException {
        String propertyName = AddressType.LOCALITY.toTypeName();
        for (LocalityNameType type : LocalityNameType.values()) {
            JsonNode value;
            JsonNode jsonNode = value = type == LocalityNameType.NAME ? node.path(propertyName) : node.path(propertyName + type.toValue());
            if (!value.isTextual()) continue;
            LocalityName name = new LocalityName(value.asText());
            name.setNameType((NameType)(type == LocalityNameType.NAME ? null : type));
            object.getNameElements().add(name);
        }
    }

    @Override
    public void writeObject(Locality object, ObjectNode node, CityJSONSerializerHelper helper) throws CityJSONSerializeException, CityJSONWriteException {
        if (object.isSetNameElements()) {
            String propertyName = AddressType.LOCALITY.toTypeName();
            for (LocalityName name : object.getNameElements()) {
                if (name.getContent() == null) continue;
                if (name.getNameType() == null || name.getNameType() == LocalityNameType.NAME) {
                    node.put(propertyName, name.getContent());
                    continue;
                }
                node.put(propertyName + ((LocalityNameType)name.getNameType()).toValue(), name.getContent());
            }
        }
    }
}

