/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.appearance.serializer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.citygml4j.cityjson.adapter.appearance.ParameterizedTextureAdapter;
import org.citygml4j.cityjson.adapter.appearance.X3DMaterialAdapter;
import org.citygml4j.cityjson.adapter.appearance.serializer.AppearanceInfo;
import org.citygml4j.cityjson.adapter.appearance.serializer.TextureVerticesBuilder;
import org.citygml4j.cityjson.writer.CityJSONSerializerHelper;
import org.citygml4j.core.model.appearance.AbstractSurfaceData;
import org.citygml4j.core.model.appearance.Appearance;
import org.citygml4j.core.model.appearance.ParameterizedTexture;
import org.citygml4j.core.model.appearance.X3DMaterial;

public class AppearanceSerializer {
    public static final String FALLBACK_THEME = "unnamed";
    public static final int DEFAULT_TEXTURE_VERTEX_PRECISION = 7;
    private final CityJSONSerializerHelper helper;
    private final Map<Integer, AppearanceInfo> materials = new HashMap<Integer, AppearanceInfo>();
    private final Map<Integer, AppearanceInfo> textures = new HashMap<Integer, AppearanceInfo>();
    private final TextureVerticesBuilder textureVerticesBuilder = new TextureVerticesBuilder(7);
    private String fallbackTheme = "unnamed";

    public AppearanceSerializer(CityJSONSerializerHelper helper) {
        this.helper = helper;
    }

    public String getFallbackTheme() {
        return this.fallbackTheme;
    }

    public void setFallbackTheme(String fallbackTheme) {
        this.fallbackTheme = fallbackTheme != null ? fallbackTheme : FALLBACK_THEME;
    }

    public TextureVerticesBuilder getTextureVerticesBuilder() {
        return this.textureVerticesBuilder;
    }

    public AppearanceInfo getOrCreateMaterial(X3DMaterial material) {
        return this.materials.computeIfAbsent(this.computeKey(material), v -> {
            try {
                ObjectNode node = this.helper.getObjectUsingSerializer(material, X3DMaterialAdapter.class);
                return new AppearanceInfo(node, this.getTheme((AbstractSurfaceData)material), this.materials.size());
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    public boolean hasMaterials() {
        return !this.materials.isEmpty();
    }

    public Iterator<ObjectNode> getMaterials() {
        return this.materials.values().stream().sorted(Comparator.comparingInt(AppearanceInfo::getIndex)).map(AppearanceInfo::getNode).iterator();
    }

    public AppearanceInfo getOrCreateTexture(ParameterizedTexture texture) {
        return this.textures.computeIfAbsent(this.computeKey(texture), v -> {
            try {
                ObjectNode node = this.helper.getObjectUsingSerializer(texture, ParameterizedTextureAdapter.class);
                return new AppearanceInfo(node, this.getTheme((AbstractSurfaceData)texture), this.textures.size());
            }
            catch (Exception e) {
                return null;
            }
        });
    }

    public boolean hasTextures() {
        return !this.textures.isEmpty();
    }

    public Iterator<ObjectNode> getTextures() {
        return this.textures.values().stream().sorted(Comparator.comparingInt(AppearanceInfo::getIndex)).map(AppearanceInfo::getNode).iterator();
    }

    private String getTheme(AbstractSurfaceData surfaceData) {
        String theme = null;
        Appearance appearance = (Appearance)surfaceData.getParent(Appearance.class);
        if (appearance != null) {
            theme = appearance.getTheme();
        }
        return theme != null ? theme : this.fallbackTheme;
    }

    public void reset() {
        this.materials.clear();
        this.textures.clear();
        this.textureVerticesBuilder.reset();
    }

    private int computeKey(X3DMaterial material) {
        return Objects.hash(this.getTheme((AbstractSurfaceData)material), material.getAmbientIntensity(), material.getDiffuseColor().toList(), material.getEmissiveColor().toList(), material.getSpecularColor().toList(), material.getShininess(), material.getTransparency(), material.getIsSmooth());
    }

    private int computeKey(ParameterizedTexture texture) {
        return Objects.hash(this.getTheme((AbstractSurfaceData)texture), texture.getImageURI(), texture.getMimeType() != null ? texture.getMimeType().getValue() : null, texture.getTextureType(), texture.getWrapMode(), texture.getBorderColor() != null ? texture.getBorderColor().toList() : null);
    }
}

