/*
 * Decompiled with CFR 0.152.
 */
package org.citygml4j.cityjson.adapter.appearance.serializer;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.citygml4j.cityjson.model.geometry.TextureVertex;
import org.citygml4j.cityjson.util.ArrayBuffer;

public class TextureVerticesBuilder {
    private Map<String, Integer> indexes = new HashMap<String, Integer>();
    private ArrayBuffer<TextureVertex> vertices = new ArrayBuffer();
    private int precision;

    TextureVerticesBuilder(int precision) {
        this.precision = precision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        if (precision >= 0) {
            this.precision = precision;
        }
    }

    public List<Integer> addTextureVertices(List<Double> vertices) {
        ArrayList<Integer> indexes = new ArrayList<Integer>(vertices.size() / 2);
        int size = vertices.size();
        for (int i = 0; i < size && i + 2 <= size; i += 2) {
            double s = this.round(vertices.get(i));
            double t = this.round(vertices.get(i + 1));
            String key = Double.toString(s) + t;
            Integer index = this.indexes.get(key);
            if (index == null) {
                index = this.vertices.size();
                this.vertices.add(TextureVertex.of(s, t));
                this.indexes.put(key, index);
            }
            indexes.add(index);
        }
        return indexes;
    }

    public ArrayBuffer<TextureVertex> build() {
        this.indexes.clear();
        return this.vertices;
    }

    public void reset() {
        this.indexes = new HashMap<String, Integer>();
        this.vertices = new ArrayBuffer();
    }

    public double round(double value) {
        return BigDecimal.valueOf(value).setScale(this.precision, RoundingMode.HALF_UP).doubleValue();
    }
}

